% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{fl70}
\alias{fl70}
\title{Florida 70 Precinct Shape File}
\format{
sf data.frame containing columns for useful data related to the
redistricting process, subsetted from real data in Florida, and sf geometry column.
\describe{
\item{\code{geoid}}{ Contains unique identifier for each precinct which can be matched to the full Florida dataset.}
\item{\code{pop}}{ Contains the population of each precinct.}
\item{\code{vap}}{ Contains the voting age population of each precinct.}
\item{\code{obama}}{ Contains the 2012 presidential vote for Obama.}
\item{\code{mccain}}{ Contains the 2012 presidential vote for McCain.}
\item{\code{TotPop}}{ Contains the population of each precinct. Identical to pop.}
\item{\code{BlackPop}}{Contains the black population of each precinct.}
\item{\code{HispPop}}{Contains the Hispanic population of each precinct.}
\item{\code{VAP}}{ Contains the voting age population of each precinct. Identical to vap.}
\item{\code{BlackVAP}}{ Contains the voting age population of black constituents of each precinct.}
\item{\code{HispVAP}}{ Contains the voting age population of hispanic constituents of each precinct.}
\item{\code{geometry}}{ Contains sf geometry of each precinct.}
}
}
\usage{
data("fl70")
}
\description{
This data set contains the 70 Precinct shapefile and related data for each precinct.
}
\details{
It is a random 70 precinct connected subset from Florida's precincts. This was introduced by
<doi: 10.1080/2330443X.2020.1791773>
}
\examples{
\dontrun{
data(fl70)
}
}
\references{
Benjamin Fifield, Kosuke Imai, Jun Kawahara & Christopher T. Kenny (2020)
The Essential Role of Empirical Validation in Legislative Redistricting Simulation,
Statistics and Public Policy, 7:1, 52-68, DOI: 10.1080/2330443X.2020.1791773
}
\concept{data}
