% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributeAssignment.R
\name{stripHTMLandUnicode}
\alias{stripHTMLandUnicode}
\alias{unitsFieldAnnotation}
\title{Helper functions for \code{exportRecordsTyped} attributes}
\usage{
stripHTMLandUnicode(field_name, field_label, field_annotation)

unitsFieldAnnotation(field_name, field_label, field_annotation)
}
\arguments{
\item{field_name}{\code{character(n)}. Name of the fields.}

\item{field_label}{\code{character(n)}. Labels from meta data.}

\item{field_annotation}{\code{character(n)}. Annotations from meta_data.}
}
\description{
This set of functions helps in setting attributes for
columns of the resulting type cast data.frame.
}
\details{
Functions passed into the \code{assignment} parameter list of 
\code{\link{exportRecordsTyped}} construct attributes on a column. 
They are expected to have a signature of \code{function(field_name,
field_label, field_annotation)} and return the attribute to assign or NA. 
They must be vectorized.

Useful utilities are provided in \code{\link{stringCleanup}}

\code{stripHTMLandUnicode} strips both HTML and UNICODE from the field_label.

\code{unitsFieldAnnotation} pulls a units string from the field_annotation. 
An example of the form searched for is \code{units=\{"meters"\}}
}
