% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_array_conversions.R
\name{array_to_RasterStack}
\alias{array_to_RasterStack}
\title{Convert from an array to a raster stack}
\usage{
array_to_RasterStack(
  img_array,
  type = "stack",
  alpha_mask = TRUE,
  return_alpha = FALSE
)
}
\arguments{
\item{img_array}{An RGB array.}

\item{type}{Type of Raster* object to return. One of either "stack"
(\link[raster:stack]{raster::stack}) or "brick" (\link[raster:brick]{raster::brick}).}

\item{alpha_mask}{Logical. Use the alpha channel as a background mask?}

\item{return_alpha}{Logical. Return the alpha channel as a layer?}
}
\value{
A Raster* object, either \code{RasterStack} or \code{RasterBrick} depending
on the \code{type} argument.
}
\description{
Convert from an image array to a raster stack, optionally using the alpha
channel as a mask.
}
