% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{step_select}
\alias{step_select}
\alias{tidy.step_select}
\title{Select variables using dplyr}
\usage{
step_select(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  skip = FALSE,
  id = rand_id("select")
)

\method{tidy}{step_select}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be selected when baking. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{For model terms selected by this step, what analysis
role should they be assigned?}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_select} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with column \code{terms} which
contains the \code{select} expressions as character strings
(and are not reparsable).
}
\description{
\code{step_select()} creates a \emph{specification} of a recipe step
that will select variables using \code{\link[dplyr:select]{dplyr::select()}}.
}
\details{
When an object in the user's global environment is
referenced in the expression defining the new variable(s),
it is a good idea to use quasiquotation (e.g. \verb{!!}) to embed
the value of the object in the expression (to be portable
between sessions). See the examples.
}
\examples{
library(dplyr)

iris_tbl <- as_tibble(iris)
iris_train <- slice(iris_tbl, 1:75)
iris_test <- slice(iris_tbl, 76:150)

dplyr_train <- select(iris_train, Species, starts_with("Sepal"))
dplyr_test <- select(iris_test, Species, starts_with("Sepal"))

rec <- recipe(~., data = iris_train) \%>\%
  step_select(Species, starts_with("Sepal")) \%>\%
  prep(training = iris_train)

rec_train <- bake(rec, new_data = NULL)
all.equal(dplyr_train, rec_train)

rec_test <- bake(rec, iris_test)
all.equal(dplyr_test, rec_test)

# Local variables
sepal_vars <- c("Sepal.Width", "Sepal.Length")

qq_rec <-
  recipe(~., data = iris_train) \%>\%
  # fine for interactive usage
  step_select(Species, all_of(sepal_vars)) \%>\%
  # best approach for saving a recipe to disk
  step_select(Species, all_of(!!sepal_vars))

# Note that `sepal_vars` is inlined in the second approach
qq_rec
}
\concept{preprocessing}
\concept{variable_filters}
\keyword{datagen}
