% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.lgcpReal}
\alias{plot.lgcpReal}
\title{Real-time surveillance plot}
\usage{
\method{plot}{lgcpReal}(
  x,
  covariates,
  osm = FALSE,
  per.days = 10000,
  change.lag = NULL,
  relative = TRUE,
  msq = 10000,
  rr_lim = NULL,
  ...
)
}
\arguments{
\item{x}{An lgcpReal object, output from a call to \code{lgcp}}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest and containing
the covariate and population density data. Typically the same object as specified in the
\code{covariates} argument in the call to \code{lgcp}.}

\item{osm}{A logical value whether a map from OpenStreetMap should be included in the plots.}

\item{per.days}{Integer, the number of person-days to use for incidence, default is 10,000.}

\item{change.lag}{If not NULL, then plots are created of the change in outputs compared to
this number of periods prior.}

\item{relative}{A logical value indicating whether the comparisons (if change.lag set) should be relative (default),
i.e. incidence rate ratios and ratios of relative risks, or absolute.}

\item{msq}{Integer, the denominator of the population density, default is hectares (population per
10,000m^2)}

\item{rr_lim}{Integer, for plotting the relative risk, the maximum value of the colour scale. Useful
when comparing multiple plots to put colour gradient on same scale.}

\item{...}{...}
}
\value{
A list of two ggplot objects. The first is the incidence (or change in incidence) the
second is a plot of four components: (i) the expected case count in each cell, (ii) the
relative risk due to included covariates, (iii) the relative risk associated with the
latent Gaussian process, and (iv) the posterior standard deviation of the incidence. An object
\code{outl} is exported to the global environment to reduce needing to reload sampling
data on further calls to the same \code{lgcpReal} object. This can be removed if needed as
it can be large.
}
\description{
Plot incidence, model components, and their changes over time.
}
\examples{
\donttest{
data(dat,square,square_pop)
lg1 <- lgcp(data=dat,
            pop.var = c("popdens"),
            boundary=square,
            covariates=square_pop,
            cellwidth=0.1,
            laglength = 7,
            mala.pars=c(200,100,1),
            nchains=2)
plot(lg1,square_pop)
}
}
\seealso{
aggregator, plot_hotspot, generate_report
}
