% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_utils.R
\name{stan_data}
\alias{stan_data}
\title{Stan's data block for ODE models}
\usage{
stan_data(vars_vector, type, inits = TRUE)
}
\arguments{
\item{vars_vector}{a string vector. Each element corresponds to a vector's
name for which users will supply data.}

\item{type}{a string vector. It must have the same length as vars_vector .
This parameter indicates the type of the variables declared by
vars_vector.}

\item{inits}{a boolean. Indicates whether the block includes the declaration
for stocks' init values.}
}
\value{
a string that contains the Stan code for the data block.
}
\description{
Stan's data block for ODE models
}
\examples{
stan_data("y", "int")
stan_data("y", "real", FALSE)
}
