% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_labjs.R
\name{process_labjs}
\alias{process_labjs}
\title{Process lab.js data stored in survey software}
\usage{
process_labjs(
  data,
  labjs_column,
  keep = NULL,
  remove_no_json = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{a data.frame.}

\item{labjs_column}{a character string specifying the column in \code{data}
that contains the lab.js data.}

\item{keep}{a character vector specifying which additional columns in
\code{data} should be kept.}

\item{remove_no_json}{logical indicating whether rows with no JSON data
should be kept. Only relevant if \code{keep} contains one or more
variables.}

\item{verbose}{logical indicating whether function should report its
progress.}

\item{...}{additional arguments passed on to \link[jsonlite]{fromJSON}.}
}
\value{
A \link{data.frame} containing the processed data.
}
\description{
Process lab.js data stored in survey software by converting them from JSON
data to a data.frame in long format. This function is currently in beta mode.
}
\examples{
\dontrun{
raw_data <- read.csv("raw_data.csv",encoding="UTF-8")

dataset <- process_labjs(data=raw_data,
  labjs_column = "FB01_01",
  keep=c("CASE","SERIAL"),
  verbose=TRUE)
}

}
\author{
Felix Henninger (\email{mailbox@felixhenninger.com})

Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})
}
