% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs_local.R
\name{read_abs_local}
\alias{read_abs_local}
\title{Read and tidy locally-saved ABS time series spreadsheet(s)}
\usage{
read_abs_local(
  cat_no = NULL,
  filenames = NULL,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir()),
  use_fst = TRUE,
  metadata = TRUE
)
}
\arguments{
\item{cat_no}{character; a single catalogue number such as "6202.0".
When \code{cat_no} is specified, all local files in \code{path} corresponding to
the specified catalogue number will be imported.
For example, if you run \code{read_abs_local("6202.0")}, it will look in
the \code{6202.0} sub-folder of \code{path} and attempt to load any
.xls and .xlsx files in that location.
If \verb{cat_no`` is specified, }filenames` will be ignored.}

\item{filenames}{character vector of at least one filename of a
locally-stored ABS time series spreadsheet. For example, "6202001.xls" or
c("6202001.xls", "6202005.xls"). Ignored if a value is supplied to \code{cat_no}.
If \code{filenames} is blank and \code{cat_no} is blank, \code{read_abs_local()} will
attempt to read all .xls and .xlsx files in the directory specified with \code{path}.}

\item{path}{path to local directory containing ABS time series file(s).
Default is \code{Sys.getenv("R_READABS_PATH", unset = tempdir())}.
If nothing is specified in \code{filenames} or \code{cat_no},
\code{read_abs_local()} will attempt to read all .xls and .xlsx files in the directory
specified with \code{path}.}

\item{use_fst}{logical. If \code{TRUE} (the default) then, if an \code{fst} file of the
tidy data frame has already been saved in \code{path}, it is read immediately.}

\item{metadata}{logical. If \code{TRUE} (the default), a tidy data frame including
ABS metadata (series name, table name, etc.) is included in the output. If
\code{FALSE}, metadata is dropped.}
}
\description{
If you need to download and tidy time series data from the ABS,
use \code{read_abs()}. \code{read_abs_local()} imports and tidies data
from ABS time series spreadsheets that are already saved to your local drive.
}
\details{
Unlike \code{read_abs()}, the \code{table_title} column in the data frame
returned by \code{read_abs_local()} is blank. If you require \code{table_title},
please use \code{read_abs()} instead.
}
\examples{

# Load and tidy two specified files from the "data/ABS" subdirectory
# of your working directory
\dontrun{
lfs <- read_abs_local(c("6202001.xls", "6202005.xls"))
}

}
