% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{add_subtitle}
\alias{add_subtitle}
\title{Add a subtitle above a reactable table}
\usage{
add_subtitle(
  table = NULL,
  subtitle = NULL,
  align = "left",
  font_color = "#333",
  font_family = "-apple-system,BlinkMacSystemFont,Helvetica,Arial,sans-serif",
  font_size = 24,
  font_style = "normal",
  font_weight = "bold",
  text_decoration = NULL,
  background_color = "#FFFFFF",
  margin = 2
)
}
\arguments{
\item{table}{A reactable table.}

\item{subtitle}{A string to be displayed as the subtitle.}

\item{align}{The alignment of the subtitle.
Options are "left", "right", "center".
Default is "left".}

\item{font_color}{Color of the subtitle text.
Default is #333.}

\item{font_family}{Font family of the subtitle.
Default is -apple-system, BlinkMacSystemFont, Helvetica, Arial, sans-serif.}

\item{font_size}{Numeric value representing the size of the font of the subtitle (in px).
Default is 24.}

\item{font_style}{Style of the subtitle font.
Options are "normal" or "italic".
Default is "normal".}

\item{font_weight}{The font weight of the subtitle.
Options are "bold" or "normal".
Default is "bold".}

\item{text_decoration}{Optionally add an underline, overline, or line-through subtitle.
Options are "underline", "overline", "underline overline", or "line-through".
Default is NULL.}

\item{background_color}{Color of the subtitle background.
Default is #FFFFFF.}

\item{margin}{Numeric value representing the four-sided margin around the subtitle (in px).
Default is 2.}
}
\value{
a function that adds a subtitle above a reactable table.
}
\description{
Use `add_subtitle()` to place a subtitle above a {reactable} or {reactablefmtr} table.
     The same options that are present in `add_title()` and `add_source()` are also available in `add_subtitle()`.
     The subtitle can be aligned to the left, right, or center with the align option.
     The text properties of the subtitle, such as the font size, font family, and font style can be customized.
     The background color of the subtitle can also be adjusted as well as the margin around the subtitle.
}
\examples{
\dontrun{
## Create the reactable table and then pipe in the subtitle
table <- reactable(iris[10:29, ])

table \%>\%
  add_subtitle("This is a subtitle")

## If a title proceeds a subtitle, the subtite will be placed below the title
table \%>\%
  add_title("This is a title") \%>\%
  add_subtitle("This is a subtitle")

## Use options to adjust the style and position of the subtitle
table \%>\%
  add_subtitle("This is a subtitle", align = "center", font_color = "red")
}
}
