% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reReg_pkg.R
\docType{package}
\name{reReg-package}
\alias{reReg-package}
\alias{_PACKAGE}
\alias{reReg-packages}
\title{reReg: Recurrent Event Regression}
\description{
The package offers a comprehensive collection of practical and easy-to-use tools for analyzing
recurrent event data, with or without the presence of a (possibly) correlated terminal event.
The modeling framework is basedon a joint frailty scale-change model,
that encompasses many existing models, including the popular Cox-type models,
as special cases and accommodates informative censoring through a subject-specific frailty.
The implemented estimating procedure does not require any parametric assumption on the frailty
distribution.
The package allows the users to specify different model forms for both the recurrent event process
and the terminal event.
The package also included are visualization of recurrent events and
simulation from the regression models.
}
\references{
Lin, D., Wei, L., Yang, I. and Ying, Z. (2000). Semiparametric Regression for the Mean and Rate Functions of Recurrent Events.
\emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \bold{62}: 711--730.

Wang, M.-C., Qin, J., and Chiang, C.-T. (2001). Analyzing Recurrent Event Data with Informative Censoring.
\emph{Journal of the American Statistical Association}, \bold{96}(455): 1057--1065.

Ghosh, D. and Lin, D.Y. (2002). Marginal Regression Models for Recurrent and Terminal Events. \emph{Statistica Sinica}: 663--688.

Ghosh, D. and Lin, D.Y. (2003). Semiparametric Analysis of Recurrent Events Data in the Presence of Dependent Censoring.
\emph{Biometrics}, \bold{59}: 877--885.

Huang, C.-Y. and Wang, M.-C. (2004). Joint Modeling and Estimation for Recurrent Event Processes and Failure Time Data.
\emph{Journal of the American Statistical Association}, \bold{99}(468): 1153--1165.

Xu, G., Chiou, S.H., Huang, C.-Y., Wang, M.-C. and Yan, J. (2017).
Joint Scale-change Models for Recurrent Events and Failure Time.
\emph{Journal of the American Statistical Association}, \bold{112}(518): 796--805.

Xu, G., Chiou, S.H.,Yan, J., Marr, K., and Huang, C.-Y. (2019). Generalized Scale-Change Models for Recurrent Event
Processes under Informative Censoring. \emph{Statistica Sinica}, \bold{30}: 1773--1795.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/stc04003/reReg}
  \item Report bugs at \url{https://github.com/stc04003/reReg/issues}
}

}
\author{
\strong{Maintainer}: Sy Han (Steven) Chiou \email{schiou@utdallas.edu}

Authors:
\itemize{
  \item Chiung-Yu  Huang \email{ChiungYu.Huang@ucsf.edu}
}

}
