% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{re2_detect}
\alias{re2_detect}
\title{Test a pattern in strings, and return boolean.}
\usage{
re2_detect(string, pattern, anchor = UNANCHORED, parallel = FALSE,
  grain_size = 1e+05, ...)
}
\arguments{
\item{string}{a character vector}

\item{pattern}{a character vector or pre-compiled regular expressions}

\item{anchor}{see \code{\link{UNANCHORED}}}

\item{parallel}{use multithread}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
A logical vector.
}
\description{
Test a pattern in strings, and return boolean. Vectorised over strings and patterns.
}
\examples{
re2_detect("one", "(o.e)")
re2_detect("123-234-2222", "\\\\d\\\\d\\\\d-\\\\d\\\\d\\\\d-\\\\d\\\\d\\\\d\\\\d")

words = c("sunny","beach","happy","really")
re2_detect(words, "y")
re2_detect(words, "^b")
re2_detect(words, "[abc]")

# vectorize
(res = re2_detect("This", letters))
letters[res]

letters[re2_detect("This", letters, case_sensitive = FALSE)]

letters[re2_detect("This", re2(letters, case_sensitive = FALSE))]

# In stringi, "" empty search patterns return NA.
# In re2r, empty search patterns will match
# empty string.

re2_detect("abc", "")
stringi::stri_detect("abc", regex = "")

}
