% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drop_acc.R
\name{drop_acc}
\alias{drop_acc}
\title{Dropbox account information}
\usage{
drop_acc(dtoken = get_dropbox_token(), verbose = FALSE)
}
\arguments{
\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}.
rdrop2 will try to automatically locate your local credential cache and use
them. However, if the credentials are not found, the function will initiate
a new authentication request. You can override this by pointing to a
different location where your credentials are stored.}

\item{verbose}{By default verbose output is \code{FALSE}. Set to \code{TRUE}
if you need to troubleshoot any output or grab additional parameters.}
}
\description{
Retrieves information about the user's account. Returns the following fields:  \code{referral_link}, \code{display_name},  \code{uid}, \code{locale}, \code{email_verified}, \code{quota_info.datastores}, \code{quota_info.shared}, \code{quota_info.quota}, \code{quota_info.normal}, \code{is_paired}, \code{country}, \code{name_details.familiar_name}, \code{name_details.surname}, \code{name_details.given_name}, \code{email}
}
\examples{
\dontrun{
drop_acc()
# Select name and UID
drop_acc() \%>\% select(uid, display_name, quota_info.normal)
}
}

