% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdmcplot.R
\name{rdmcplot}
\alias{rdmcplot}
\title{RD plots with multiple cutoffs.}
\usage{
rdmcplot(
  Y,
  X,
  C,
  nbinsmat = NULL,
  binselectvec = NULL,
  scalevec = NULL,
  supportmat = NULL,
  pvec = NULL,
  hmat = NULL,
  kernelvec = NULL,
  weightsvec = NULL,
  covsvec = NULL,
  covs_evalvec = NULL,
  covs_dropvec = NULL,
  ci = NULL,
  col_bins = NULL,
  pch_bins = NULL,
  col_poly = NULL,
  lty_poly = NULL,
  col_xline = NULL,
  lty_xline = NULL,
  nobins = FALSE,
  nopoly = FALSE,
  noxline = FALSE,
  nodraw = FALSE
)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{cutoff variable.}

\item{nbinsmat}{matrix of cutoff-specific number of bins. See \code{rdplot()}
for details.}

\item{binselectvec}{vector of cutoff-specific bins selection method. See
\code{rdplot()} for details.}

\item{scalevec}{vector of cutoff-specific scale factors. See \code{rdplot()}
for details.}

\item{supportmat}{matrix of cutoff-specific support conditions. See
\code{rdplot()} for details..}

\item{pvec}{vector of cutoff-specific polynomial orders. See \code{rdplot()}
for details.}

\item{hmat}{matrix of cutoff-specific bandwidths. See \code{rdplot()} for
details.}

\item{kernelvec}{vector of cutoff-specific kernels. See \code{rdplot()} for
details.}

\item{weightsvec}{vector of cutoff-specific weights. See \code{rdplot()} for
details.}

\item{covsvec}{vector of cutoff-specific covariates. See \code{rdplot()} for
details.}

\item{covs_evalvec}{vector indicating the evaluation point for additional
covariates should be dropped at each cutoff. See \code{rdrobust()} for
details.}

\item{covs_dropvec}{vector indicating whether collinear covariates should be
dropped at each cutoff. See \code{rdrobust()} for details.}

\item{ci}{adds confidence intervals of the specified level to the plot. See
\code{rdrobust()} for details.}

\item{col_bins}{vector of colors for bins.}

\item{pch_bins}{vector of characters (pch) type for bins.}

\item{col_poly}{vector of colors for polynomial curves.}

\item{lty_poly}{vector of lty for polynomial curves.}

\item{col_xline}{vector of colors for vertical lines.}

\item{lty_xline}{vector of lty for vertical lines.}

\item{nobins}{omits bins plot.}

\item{nopoly}{omits polynomial curve plot.}

\item{noxline}{omits vertical lines indicating the cutoffs.}

\item{nodraw}{omits plot.}
}
\value{
\item{clist}{list of cutoffs}
\item{cnum}{number of cutoffs}
\item{X0}{matrix of X values for control units}
\item{X1}{matrix of X values for treated units}
\item{Yhat0}{estimated polynomial for control units}
\item{Yhat1}{estimated polynomial for treated units}
\item{Xmean}{bin average of X values}
\item{Ymean}{bin average for Y values}
\item{CI_l}{lower end of confidence intervals}
\item{CI_r}{upper end of confidence intervals}
}
\description{
\code{rdmcplot()} RD plots with multiple cutoffs.
}
\examples{
# Toy dataset
X <- runif(1000,0,100)
C <- c(rep(33,500),rep(66,500))
Y <- (1 + X + (X>=C))*(C==33)+(.5 + .5*X + .8*(X>=C))*(C==66) + rnorm(1000)
# rdmcplot with standard syntax
tmp <- rdmcplot(Y,X,C)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2020). \href{https://sites.google.com/site/rdpackages/rdmulti/Cattaneo-Titiunik-VazquezBare_2020_Stata.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Working paper}.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
