% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{download_datasets}
\alias{download_datasets}
\title{Create a data frame of datasets that your log in can download}
\usage{
download_datasets(
  config,
  desired_dataset,
  download_option = "both",
  reformat = TRUE,
  all_lower = TRUE,
  output_dir_root = NULL,
  ...
)
}
\arguments{
\item{config}{Object of class `rdhs_config` as produced by `read_rdhs_config`
that must contain a valid `email`, `project` and `password`.}

\item{desired_dataset}{Row from \code{available_datasets}}

\item{download_option}{Character dictating how the survey is stored when
downloaded. Must be one of:
\itemize{
    \item{"zip"} - Just the zip. "z", "i", "p" or "zip" will match
    \item{"rds"} - Just the read in and saved rds. "r", "d", "s" or "rdhs"
    will match
    \item{"both"} - Both the rds and extract. "b", "o", "t", "h" or "both"
    will match
    }}

\item{reformat}{Boolean detailing whether dataset rds should be
reformatted for ease of use later. Default = TRUE}

\item{all_lower}{Logical indicating whether all value labels should be
lower case. Default to `TRUE`.}

\item{output_dir_root}{Directory where files are to be downloaded to}

\item{...}{Any other arguments to be passed to
\code{\link{read_dhs_dataset}}}
}
\description{
Download datasets specified using output of \code{available_datasets}.
}
