% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LineItemService.R
\name{dfp_getLineItemsByStatement}
\alias{dfp_getLineItemsByStatement}
\title{getLineItemsByStatement}
\usage{
dfp_getLineItemsByStatement(request_data, as_df = FALSE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getLineItemsByStatementResponse
}
\description{
Gets a LineItemPage of LineItem objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{CostType}
  \item{CreationDateTime}
  \item{DeliveryRateType}
  \item{EndDateTime}
  \item{ExternalId}
  \item{Id}
  \item{IsMissingCreatives}
  \item{IsSetTopBoxEnabled}
  \item{LastModifiedDateTime}
  \item{LineItemType}
  \item{Name}
  \item{OrderId}
  \item{StartDateTime}
  \item{Status}
  \item{Targeting}
  \item{UnitsBought}
}
}
\examples{
\dontrun{
filter <- "WHERE LineItemType='STANDARD' and Status='DELIVERING' LIMIT 10"
result <- dfp_getLineItemsByStatement(list(filterStatement=list(query=filter)))
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/LineItemService#getLineItemsByStatement}{Google Documentation for getLineItemsByStatement}
}
