% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormDistribution.R
\docType{class}
\name{LogNormDistribution}
\alias{LogNormDistribution}
\title{A parametrized log Normal probability distribution}
\description{
An R6 class representing a log Normal distribution.
}
\details{
A parametrized Log Normal distribution inheriting from class
\code{Distribution}. Swat (2017) defined seven parametrizations of the log
normal distribution.
These are linked, allowing the parameters of any one to be derived from any
other. All 7 parametrizations require two parameters as follows:
\describe{
\item{LN1}{\eqn{p_1=\mu}, \eqn{p_2=\sigma}, where \eqn{\mu} and \eqn{\sigma}
are the mean and standard deviation, both on the log scale.}
\item{LN2}{\eqn{p_1=\mu}, \eqn{p_2=v}, where \eqn{\mu} and \eqn{v} are the
mean and variance, both on the log scale.}
\item{LN3}{\eqn{p_1=m}, \eqn{p_2=\sigma}, where \eqn{m} is the median on the
natural scale and \eqn{\sigma} is the standard deviation on the log scale.}
\item{LN4}{\eqn{p_1=m}, \eqn{p_2=c_v}, where \eqn{m} is the median on the
natural scale and \eqn{c_v} is the coefficient of variation on the natural
scale.}
\item{LN5}{\eqn{p_1=\mu}, \eqn{p_2=\tau}, where \eqn{\mu} is the mean on the
log scale and \eqn{\tau} is the precision on the log scale.}
\item{LN6}{\eqn{p_1=m}, \eqn{p_2=\sigma_g}, where \eqn{m} is the median on
the natural scale and \eqn{\sigma_g} is the geometric standard deviation on
the natural scale.}
\item{LN7}{\eqn{p_1=\mu_N}, \eqn{p_2=\sigma_N}, where \eqn{\mu_N} is the mean
on the natural scale and \eqn{\sigma_N} is the standard deviation on the
natural scale.}
}
}
\note{
The log normal distribution may be used to model the uncertainty in
an estimate of relative risk (Briggs 2006, p90). If a relative risk
estimate is available with a 95\% confidence interval, the \verb{"LN7"}
parametrization
allows the uncertainty distribution to be specified directly. For example,
if RR = 0.67 with 95\% confidence interval 0.53 to 0.84 (Leaper, 2016), it
can be modelled with
\code{LogNormModVar$new("rr", "RR", p1=0.67,
p2=(0.84-0.53)/(2*1.96)), "LN7")}.
}
\references{
{
 Briggs A, Claxton K and Sculpher M. Decision Modelling for Health
 Economic Evaluation. Oxford 2006, ISBN 978-0-19-852662-9.

 Leaper DJ, Edmiston CE and Holy CE. Meta-analysis of the potential
 economic impact following introduction of absorbable antimicrobial
 sutures. \emph{British Journal of Surgery} 2017;\bold{104}:e134-e144.

 Swat MJ, Grenon P and Wimalaratne S. Ontology and Knowledge Base of
 Probability Distributions. \emph{Bioinformatics} 2016;\bold{32}:2719-2721,
 \doi{10.1093/bioinformatics/btw170}.
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Distribution]{rdecision::Distribution}} -> \code{LogNormDistribution}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LogNormDistribution-new}{\code{LogNormDistribution$new()}}
\item \href{#method-LogNormDistribution-distribution}{\code{LogNormDistribution$distribution()}}
\item \href{#method-LogNormDistribution-sample}{\code{LogNormDistribution$sample()}}
\item \href{#method-LogNormDistribution-mean}{\code{LogNormDistribution$mean()}}
\item \href{#method-LogNormDistribution-mode}{\code{LogNormDistribution$mode()}}
\item \href{#method-LogNormDistribution-SD}{\code{LogNormDistribution$SD()}}
\item \href{#method-LogNormDistribution-quantile}{\code{LogNormDistribution$quantile()}}
\item \href{#method-LogNormDistribution-clone}{\code{LogNormDistribution$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="order"><a href='../../rdecision/html/Distribution.html#method-Distribution-order'><code>rdecision::Distribution$order()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="r"><a href='../../rdecision/html/Distribution.html#method-Distribution-r'><code>rdecision::Distribution$r()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="varcov"><a href='../../rdecision/html/Distribution.html#method-Distribution-varcov'><code>rdecision::Distribution$varcov()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-new"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-new}{}}}
\subsection{Method \code{new()}}{
Create a log normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$new(p1, p2, parametrization = "LN1")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p1}}{First hyperparameter, a measure of location. See
\emph{Details}.}

\item{\code{p2}}{Second hyperparameter, a measure of spread. See \emph{Details}.}

\item{\code{parametrization}}{A character string taking one of the values
\verb{"LN1"} (default) through \verb{"LN7"} (see \emph{Details}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{LogNormDistribution} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string (\verb{"LN1"}, \verb{"LN2"}
etc.).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-sample"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-sample}{}}}
\subsection{Method \code{sample()}}{
Draw a random sample from the model variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$sample(expected = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected}}{If TRUE, sets the next value retrieved by a call to
\code{r()} to be the mean of the distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated \code{LogNormDistribution} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-mean"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-mode"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-mode}{}}}
\subsection{Method \code{mode()}}{
Return the point estimate of the variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Point estimate (mode) of the log normal distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-SD"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-quantile}{}}}
\subsection{Method \code{quantile()}}{
Return the quantiles of the log normal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LogNormDistribution-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LogNormDistribution-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
