% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_imputation}
\alias{ddi_imputation}
\title{imputation node}
\usage{
ddi_imputation(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
According to the Statistical Terminology glossary maintained by the National
Science Foundation, this is "the process by which one estimates missing
values for items that a survey respondent failed to provide," and if
applicable in this context, it refers to the type of procedure used. When
applied to an nCube, imputation takes into consideration all of the
dimensions that are part of that nCube. This element may be repeated to
support multiple language expressions of the content. More information on
this element, especially its allowed attributes, can be found in the
references.
}
\details{
\emph{Parent nodes}

\code{imputation} is contained in \code{nCube} and \code{var}.
}
\examples{
ddi_imputation("This variable contains values that were derived by substitution.")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/imputation.html}{imputation documentation}
}
