% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cr_fundref}
\alias{cr_fundref}
\title{Search the CrossRef Fundref API}
\usage{
cr_fundref(dois = NULL, query = NULL, filter = NULL, offset = NULL,
  limit = NULL, sample = NULL, sort = NULL, order = NULL,
  works = FALSE, .progress = "none", ...)
}
\arguments{
\item{dois}{Search by a single DOI or many DOIs.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter,
the rows and offset parameters are ignored.}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed,
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", "tk", "win,
and "time".  See \code{\link[plyr]{create_progress_bar}} for details of each.}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\description{
Search the CrossRef Fundref API
}
\details{
BEWARE: The API will only work for CrossRef DOIs.
}
\examples{
\donttest{
cr_fundref(query="NSF", limit=1)
}

\dontrun{
cr_fundref(query="NSF")
cr_fundref(dois='10.13039/100000001')
out <- cr_fundref(dois=c('10.13039/100000001','10.13039/100000015'))
out['10.13039/100000001']
out[['10.13039/100000001']]

cr_fundref(dois='10.13039/100000001')
cr_fundref(dois='10.13039/100000001', works=TRUE, limit=5)

cr_fundref(dois=c('10.13039/100000001','10.13039/100000015'))
cr_fundref(dois=c('10.13039/100000001','10.13039/100000015'), works=TRUE)

# Curl options
library('httr')
cr_fundref(dois='10.13039/100000001', config=verbose())
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

