% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseHuber.r
\name{groupwiseHuber}
\alias{groupwiseHuber}
\title{Groupwise Huber M-estimators and confidence intervals}
\usage{
groupwiseHuber(data, group, var, conf.level = 0.95, conf.type = "wald", ...)
}
\arguments{
\item{data}{The data frame to use.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{conf.level}{The confidence interval to use.}

\item{conf.type}{The type of confidence interval to use. Can be
\code{"wald"} or \code{"boot"}.
See \code{\link{HuberM}} for details.}

\item{...}{Other arguments passed to the \code{HuberM} function.}
}
\value{
A data frame of requested statistics by group.
}
\description{
Calculates Huber M-estimator and confidence intervals for
             groups.
}
\details{
A wrapper for the \code{\link{HuberM}} function
         to allow easy output for multiple groups.
}
\examples{
data(Catbus)
groupwiseHuber(data      = Catbus,
               var       = "Steps",
               group     = c("Teacher", "Sex"),
               conf.type = "wald")
                      
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/rcompanion/d_08a.html}
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseMedian}}
         \code{\link{groupwiseGeometric}}
}
\concept{
huber m-estimator confidence interval robust bootstrap
}

