/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.stereo.AbstractStereo;

public final class ExtendedCisTrans
extends AbstractStereo<IBond, IBond> {
    public ExtendedCisTrans(IBond focus, IBond[] peripherals, int config) {
        super((IChemObject)focus, (IChemObject[])peripherals, 0x2200 | 0xFF & config);
    }

    private static IAtom getOtherAtom(IAtomContainer mol, IAtom atom, IAtom other) {
        List<IBond> bonds = mol.getConnectedBondsList(atom);
        if (bonds.size() != 2) {
            return null;
        }
        if (bonds.get(0).contains(other)) {
            return bonds.get(1).getOrder() == IBond.Order.DOUBLE ? bonds.get(1).getOther(atom) : null;
        }
        return bonds.get(0).getOrder() == IBond.Order.DOUBLE ? bonds.get(0).getOther(atom) : null;
    }

    public static IAtom[] findTerminalAtoms(IAtomContainer container, IBond focus) {
        IAtom a = focus.getBegin();
        IAtom b = focus.getEnd();
        IAtom aPrev = a;
        IAtom bPrev = b;
        IAtom aNext = ExtendedCisTrans.getOtherAtom(container, a, b);
        IAtom bNext = ExtendedCisTrans.getOtherAtom(container, b, a);
        while (aNext != null && bNext != null) {
            IAtom tmp = ExtendedCisTrans.getOtherAtom(container, aNext, aPrev);
            aPrev = aNext;
            aNext = tmp;
            tmp = ExtendedCisTrans.getOtherAtom(container, bNext, bPrev);
            bPrev = bNext;
            bNext = tmp;
        }
        if (aPrev != null && bPrev != null) {
            return new IAtom[]{aPrev, bPrev};
        }
        return null;
    }

    @Override
    protected IStereoElement<IBond, IBond> create(IBond focus, List<IBond> carriers, int cfg) {
        return new ExtendedCisTrans(focus, carriers.toArray(new IBond[2]), cfg);
    }
}

