/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class XLogPDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private boolean salicylFlag = false;
    private static final String[] NAMES = new String[]{"XLogP"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#xlogP", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 2) {
            throw new CDKException("XLogPDescriptor expects two parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        if (!(params[1] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
        this.salicylFlag = (Boolean)params[1];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity, this.salicylFlag};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        SmartsPattern orthopair;
        UniversalIsomorphismTester universalIsomorphismTester;
        double xlogP;
        IAtomContainer ac;
        block207: {
            int i;
            try {
                ac = atomContainer.clone();
                AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(ac);
                CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(ac.getBuilder());
                hAdder.addImplicitHydrogens(ac);
                AtomContainerManipulator.convertImplicitToExplicitHydrogens(ac);
            }
            catch (CloneNotSupportedException e) {
                return this.getDummyDescriptorValue(e);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
            IRingSet rs = Cycles.sssr(ac).toRingSet();
            IRingSet atomRingSet = null;
            if (this.checkAromaticity) {
                try {
                    Aromaticity.cdkLegacy().apply(ac);
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue(e);
                }
            }
            xlogP = 0.0;
            String symbol = "";
            int bondCount = 0;
            int atomCount = ac.getAtomCount();
            int hsCount = 0;
            double xlogPOld = 0.0;
            IBond.Order maxBondOrder = IBond.Order.SINGLE;
            ArrayList<Integer> hBondAcceptors = new ArrayList<Integer>();
            ArrayList<Integer> hBondDonors = new ArrayList<Integer>();
            int checkAminoAcid = 1;
            IAtom atomi = null;
            for (i = 0; i < atomCount; ++i) {
                atomi = ac.getAtom(i);
                atomRingSet = rs.getRings(atomi);
                atomi.setProperty("IS_IN_AROMATIC_RING", false);
                atomi.setProperty("cdk:Part of ring of size", 0);
                if (atomRingSet.getAtomContainerCount() <= 0) continue;
                if (atomRingSet.getAtomContainerCount() > 1) {
                    Iterator<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(atomRingSet).iterator();
                    atomRingSet = rs.getBuilder().newInstance(IRingSet.class, new Object[0]);
                    while (containers.hasNext()) {
                        atomRingSet.add(Cycles.essential(containers.next()).toRingSet());
                    }
                }
                for (int j = 0; j < atomRingSet.getAtomContainerCount(); ++j) {
                    if (j == 0) {
                        atomi.setProperty("cdk:Part of ring of size", ((IRing)atomRingSet.getAtomContainer(j)).getRingSize());
                    }
                    if (!((IRing)atomRingSet.getAtomContainer(j)).contains(atomi)) continue;
                    if (((IRing)atomRingSet.getAtomContainer(j)).getRingSize() >= 6 && atomi.getFlag(32)) {
                        atomi.setProperty("IS_IN_AROMATIC_RING", true);
                    }
                    if (((IRing)atomRingSet.getAtomContainer(j)).getRingSize() >= (Integer)atomi.getProperty("cdk:Part of ring of size")) continue;
                    atomi.setProperty("cdk:Part of ring of size", ((IRing)atomRingSet.getAtomContainer(j)).getRingSize());
                }
            }
            for (i = 0; i < atomCount; ++i) {
                int halcount;
                atomi = ac.getAtom(i);
                if (xlogPOld == xlogP & i > 0 & !symbol.equals("H")) {
                    // empty if block
                }
                xlogPOld = xlogP;
                symbol = atomi.getSymbol();
                bondCount = ac.getConnectedBondsCount(atomi);
                hsCount = this.getHydrogenCount(ac, atomi);
                maxBondOrder = ac.getMaximumBondOrder(atomi);
                if (!symbol.equals("H")) {
                    // empty if block
                }
                if (symbol.equals("C")) {
                    if (bondCount == 2) {
                        if (hsCount >= 1) {
                            xlogP += 0.209;
                        } else if (maxBondOrder == IBond.Order.DOUBLE) {
                            xlogP += 2.073;
                        } else if (maxBondOrder == IBond.Order.TRIPLE) {
                            xlogP += 0.33;
                        }
                    }
                    if (bondCount == 3) {
                        if (((Boolean)atomi.getProperty("IS_IN_AROMATIC_RING")).booleanValue()) {
                            if (this.getAromaticCarbonsCount(ac, atomi) >= 2 && this.getAromaticNitrogensCount(ac, atomi) == 0) {
                                xlogP = hsCount == 0 ? (this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.296) : (xlogP -= 0.151)) : (xlogP += 0.337);
                            } else if (this.getAromaticNitrogensCount(ac, atomi) >= 1) {
                                if (hsCount == 0) {
                                    xlogP = this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.174) : (xlogP += 0.366);
                                } else if (this.getHydrogenCount(ac, atomi) == 1) {
                                    xlogP += 0.126;
                                }
                            }
                        } else {
                            if (hsCount == 0) {
                                if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                    xlogP = this.getPiSystemsCount(ac, atomi) <= 1 ? (xlogP += 0.05) : (xlogP += 0.013);
                                } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                    xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP -= 0.03) : (xlogP -= 0.027);
                                } else if (this.getAtomTypeXCount(ac, atomi) == 2) {
                                    xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP += 0.005) : (xlogP -= 0.315);
                                }
                            }
                            if (hsCount == 1) {
                                if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                                        xlogP += 0.466;
                                    }
                                    if (this.getPiSystemsCount(ac, atomi) == 1) {
                                        xlogP += 0.136;
                                    }
                                } else {
                                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                                        xlogP += 0.001;
                                    }
                                    if (this.getPiSystemsCount(ac, atomi) == 1) {
                                        xlogP -= 0.31;
                                    }
                                }
                            }
                            if (hsCount == 2) {
                                xlogP += 0.42;
                            }
                            if (this.getIfCarbonIsHydrophobic(ac, atomi)) {
                                xlogP += 0.211;
                            }
                        }
                    }
                    if (bondCount == 4) {
                        if (hsCount == 0) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP -= 0.006;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.57;
                                }
                                if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                    xlogP -= 0.317;
                                }
                            } else {
                                xlogP = this.getPiSystemsCount(ac, atomi) == 0 ? (xlogP -= 0.316) : (xlogP -= 0.723);
                            }
                        }
                        if (hsCount == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.127;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.243;
                                }
                                if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                    xlogP -= 0.499;
                                }
                            } else {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP -= 0.205;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.305;
                                }
                                if (this.getPiSystemsCount(ac, atomi) >= 2) {
                                    xlogP -= 0.709;
                                }
                            }
                        }
                        if (hsCount == 2) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.358;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.008;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 2) {
                                    xlogP -= 0.185;
                                }
                            } else {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP -= 0.137;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.303;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 2) {
                                    xlogP -= 0.815;
                                }
                            }
                        }
                        if (hsCount > 2) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.528;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP += 0.267;
                                }
                            } else {
                                xlogP -= 0.032;
                            }
                        }
                        if (this.getIfCarbonIsHydrophobic(ac, atomi)) {
                            xlogP += 0.211;
                        }
                    }
                }
                if (symbol.equals("N")) {
                    if (ac.getBondOrderSum(atomi) >= 3.0 && this.getOxygenCount(ac, atomi) >= 2 && maxBondOrder == IBond.Order.DOUBLE) {
                        xlogP += 1.178;
                    } else if (this.getPresenceOfCarbonil(ac, atomi) >= 1) {
                        if (hsCount == 0) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                xlogP += 0.078;
                            }
                            if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                xlogP -= 0.118;
                            }
                        }
                        if (hsCount == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                xlogP -= 0.096;
                                hBondDonors.add(i);
                            } else {
                                xlogP -= 0.044;
                                hBondDonors.add(i);
                            }
                        }
                        if (hsCount == 2) {
                            xlogP -= 0.646;
                            hBondDonors.add(i);
                        }
                    } else if (bondCount == 1) {
                        if (this.getCarbonsCount(ac, atomi) == 1) {
                            xlogP -= 0.566;
                        }
                    } else if (bondCount == 2) {
                        if (((Boolean)atomi.getProperty("IS_IN_AROMATIC_RING")).booleanValue()) {
                            xlogP -= 0.493;
                            if (checkAminoAcid != 0) {
                                ++checkAminoAcid;
                            }
                        } else if (this.getDoubleBondedCarbonsCount(ac, atomi) == 0) {
                            if (this.getDoubleBondedNitrogenCount(ac, atomi) == 0 && this.getDoubleBondedOxygenCount(ac, atomi) == 1) {
                                xlogP += 0.427;
                            }
                            if (this.getDoubleBondedNitrogenCount(ac, atomi) == 1) {
                                if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                    xlogP += 0.536;
                                }
                                if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                    xlogP -= 0.597;
                                }
                            }
                        } else if (this.getDoubleBondedCarbonsCount(ac, atomi) == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.007;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.275;
                                }
                            } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.366;
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP += 0.251;
                                }
                            }
                        }
                    } else if (bondCount == 3) {
                        if (hsCount == 0) {
                            if (atomi.getFlag(32) || rs.contains(atomi) && (Integer)atomi.getProperty("cdk:Part of ring of size") > 3 && this.getPiSystemsCount(ac, atomi) >= 1) {
                                xlogP = this.getAtomTypeXCount(ac, atomi) == 0 ? (xlogP += 0.881) : (xlogP -= 0.01);
                            } else if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.159;
                                }
                                if (this.getPiSystemsCount(ac, atomi) > 0) {
                                    xlogP += 0.761;
                                }
                            } else {
                                xlogP -= 0.239;
                            }
                        } else if (hsCount == 1) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (atomi.getFlag(32) || rs.contains(atomi) && (Integer)atomi.getProperty("cdk:Part of ring of size") > 3 && this.getPiSystemsCount(ac, atomi) >= 2) {
                                    xlogP += 0.545;
                                    hBondDonors.add(i);
                                } else {
                                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                                        xlogP -= 0.112;
                                        hBondDonors.add(i);
                                    }
                                    if (this.getPiSystemsCount(ac, atomi) > 0) {
                                        xlogP += 0.166;
                                        hBondDonors.add(i);
                                    }
                                }
                            } else if (rs.contains(atomi)) {
                                xlogP += 0.153;
                                hBondDonors.add(i);
                            } else {
                                xlogP += 0.324;
                                hBondDonors.add(i);
                            }
                        } else if (hsCount == 2) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP -= 0.534;
                                    hBondDonors.add(i);
                                }
                                if (this.getPiSystemsCount(ac, atomi) == 1) {
                                    xlogP -= 0.329;
                                    hBondDonors.add(i);
                                }
                                if (checkAminoAcid != 0) {
                                    ++checkAminoAcid;
                                }
                            } else {
                                xlogP -= 1.082;
                                hBondDonors.add(i);
                            }
                        }
                    }
                }
                if (symbol.equals("O")) {
                    if (bondCount == 1 && maxBondOrder == IBond.Order.DOUBLE) {
                        xlogP -= 0.399;
                        if (!this.getPresenceOfHydroxy(ac, atomi)) {
                            hBondAcceptors.add(i);
                        }
                    } else if (bondCount == 1 && hsCount == 0 && (this.getPresenceOfNitro(ac, atomi) || this.getPresenceOfCarbonil(ac, atomi) == 1) || this.getPresenceOfSulfat(ac, atomi)) {
                        xlogP -= 0.399;
                        if (!this.getPresenceOfHydroxy(ac, atomi)) {
                            hBondAcceptors.add(i);
                        }
                    } else if (bondCount >= 1) {
                        if (hsCount == 0 && bondCount == 2) {
                            if (this.getAtomTypeXCount(ac, atomi) == 0) {
                                if (this.getPiSystemsCount(ac, atomi) == 0) {
                                    xlogP += 0.084;
                                }
                                if (this.getPiSystemsCount(ac, atomi) > 0) {
                                    xlogP += 0.435;
                                }
                            } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                                xlogP += 0.105;
                            }
                        } else if (this.getAtomTypeXCount(ac, atomi) == 0) {
                            if (this.getPiSystemsCount(ac, atomi) == 0) {
                                xlogP -= 0.467;
                                hBondDonors.add(i);
                                hBondAcceptors.add(i);
                            }
                            if (this.getPiSystemsCount(ac, atomi) == 1) {
                                xlogP += 0.082;
                                hBondDonors.add(i);
                                hBondAcceptors.add(i);
                            }
                        } else if (this.getAtomTypeXCount(ac, atomi) == 1) {
                            xlogP -= 0.522;
                            hBondDonors.add(i);
                            hBondAcceptors.add(i);
                        }
                    }
                }
                if (symbol.equals("S")) {
                    if (bondCount == 1 && maxBondOrder == IBond.Order.DOUBLE || bondCount == 1 && atomi.getFormalCharge() == -1) {
                        xlogP -= 0.148;
                    } else if (bondCount == 2) {
                        xlogP = hsCount == 0 ? (xlogP += 0.255) : (xlogP += 0.419);
                    } else if (bondCount == 3) {
                        if (this.getOxygenCount(ac, atomi) >= 1) {
                            xlogP -= 1.375;
                        }
                    } else if (bondCount == 4 && this.getDoubleBondedOxygenCount(ac, atomi) >= 2) {
                        xlogP -= 0.168;
                    }
                }
                if (symbol.equals("P")) {
                    if (this.getDoubleBondedSulfurCount(ac, atomi) >= 1 && bondCount >= 4) {
                        xlogP += 1.253;
                    } else if (this.getOxygenCount(ac, atomi) >= 1 || this.getDoubleBondedOxygenCount(ac, atomi) == 1 && bondCount >= 4) {
                        xlogP -= 0.447;
                    }
                }
                if (symbol.equals("F")) {
                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                        xlogP += 0.375;
                    } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                        xlogP += 0.202;
                    }
                }
                if (symbol.equals("Cl")) {
                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                        xlogP += 0.512;
                    } else if (this.getPiSystemsCount(ac, atomi) >= 1) {
                        xlogP += 0.663;
                    }
                }
                if (symbol.equals("Br")) {
                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                        xlogP += 0.85;
                    } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                        xlogP += 0.839;
                    }
                }
                if (symbol.equals("I")) {
                    if (this.getPiSystemsCount(ac, atomi) == 0) {
                        xlogP += 1.05;
                    } else if (this.getPiSystemsCount(ac, atomi) == 1) {
                        xlogP += 1.109;
                    }
                }
                if ((halcount = this.getHalogenCount(ac, atomi)) == 2) {
                    xlogP += 0.137;
                } else if (halcount == 3) {
                    xlogP += 0.41100000000000003;
                } else if (halcount == 4) {
                    xlogP += 0.8220000000000001;
                }
                if (this.getPresenceOfCarbonil(ac, atomi) != 2 || rs.contains(atomi)) continue;
                xlogP += 0.58;
            }
            int[][] pairCheck = null;
            if (hBondAcceptors.size() > 0 && hBondDonors.size() > 0) {
                pairCheck = this.initializeHydrogenPairCheck(new int[atomCount][atomCount]);
            }
            AllPairsShortestPaths apsp = new AllPairsShortestPaths(ac);
            for (int i2 = 0; i2 < hBondAcceptors.size(); ++i2) {
                for (int j = 0; j < hBondDonors.size(); ++j) {
                    if (!this.checkRingLink(rs, ac, ac.getAtom((Integer)hBondAcceptors.get(i2))) && !this.checkRingLink(rs, ac, ac.getAtom((Integer)hBondDonors.get(j)))) continue;
                    int dist = apsp.from(ac.getAtom((Integer)hBondAcceptors.get(i2))).distanceTo(ac.getAtom((Integer)hBondDonors.get(j)));
                    if (this.checkRingLink(rs, ac, ac.getAtom((Integer)hBondAcceptors.get(i2))) && this.checkRingLink(rs, ac, ac.getAtom((Integer)hBondDonors.get(j)))) {
                        if (dist != 3 || pairCheck[(Integer)hBondAcceptors.get(i2)][(Integer)hBondDonors.get(j)] != 0) continue;
                        xlogP += 0.429;
                        pairCheck[((Integer)hBondAcceptors.get((int)i2)).intValue()][((Integer)hBondDonors.get((int)j)).intValue()] = 1;
                        pairCheck[((Integer)hBondDonors.get((int)j)).intValue()][((Integer)hBondAcceptors.get((int)i2)).intValue()] = 1;
                        continue;
                    }
                    if (dist != 4 || pairCheck[(Integer)hBondAcceptors.get(i2)][(Integer)hBondDonors.get(j)] != 0) continue;
                    xlogP += 0.429;
                    pairCheck[((Integer)hBondAcceptors.get((int)i2)).intValue()][((Integer)hBondDonors.get((int)j)).intValue()] = 1;
                    pairCheck[((Integer)hBondDonors.get((int)j)).intValue()][((Integer)hBondAcceptors.get((int)i2)).intValue()] = 1;
                }
            }
            universalIsomorphismTester = new UniversalIsomorphismTester();
            if (checkAminoAcid > 1) {
                QueryAtomContainer aminoAcid = QueryAtomContainerCreator.createBasicQueryContainer(this.createAminoAcid(ac.getBuilder()));
                Iterator<IBond> bonds = aminoAcid.bonds().iterator();
                IAtom bondAtom0 = null;
                IAtom bondAtom1 = null;
                while (bonds.hasNext()) {
                    IBond bond = bonds.next();
                    bondAtom0 = bond.getBegin();
                    bondAtom1 = bond.getEnd();
                    if ((!bondAtom0.getSymbol().equals("C") || !bondAtom1.getSymbol().equals("N")) && (!bondAtom0.getSymbol().equals("N") || !bondAtom1.getSymbol().equals("C") || bond.getOrder() != IBond.Order.SINGLE)) continue;
                    aminoAcid.removeBond(bondAtom0, bondAtom1);
                    QueryBond qbond = new QueryBond(bondAtom0, bondAtom1, Expr.Type.SINGLE_OR_AROMATIC);
                    aminoAcid.addBond(qbond);
                    break;
                }
                try {
                    if (!universalIsomorphismTester.isSubgraph(ac, aminoAcid)) break block207;
                    List<RMap> list = universalIsomorphismTester.getSubgraphAtomsMap(ac, aminoAcid);
                    RMap map = null;
                    IAtom atom1 = null;
                    for (int j = 0; j < list.size(); ++j) {
                        map = list.get(j);
                        atom1 = ac.getAtom(map.getId1());
                        if (!atom1.getSymbol().equals("O") || ac.getMaximumBondOrder(atom1) != IBond.Order.SINGLE || ac.getConnectedBondsCount(atom1) == 2 && this.getHydrogenCount(ac, atom1) == 0) continue;
                        xlogP -= 2.166;
                        break;
                    }
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue(e);
                }
            }
        }
        IAtomContainer paba = this.createPaba(ac.getBuilder());
        try {
            if (universalIsomorphismTester.isSubgraph(ac, paba)) {
                xlogP -= 0.501;
            }
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(e);
        }
        if (this.salicylFlag) {
            IAtomContainer salicilic = this.createSalicylicAcid(ac.getBuilder());
            try {
                if (universalIsomorphismTester.isSubgraph(ac, salicilic)) {
                    xlogP += 0.554;
                }
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        if ((orthopair = SmartsPattern.create("OccO")).matches(ac)) {
            xlogP -= 0.268;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(xlogP), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResult(0.0);
    }

    private int[][] initializeHydrogenPairCheck(int[][] pairCheck) {
        for (int i = 0; i < pairCheck.length; ++i) {
            for (int j = 0; j < pairCheck[0].length; ++j) {
                pairCheck[i][j] = 0;
            }
        }
        return pairCheck;
    }

    private boolean checkRingLink(IRingSet ringSet, IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        if (ringSet.contains(atom)) {
            return true;
        }
        for (IAtom neighbour : neighbours) {
            if (!ringSet.contains(neighbour)) continue;
            return true;
        }
        return false;
    }

    private int getHydrogenCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int hcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("H")) continue;
            ++hcounter;
        }
        return hcounter;
    }

    private int getHalogenCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int acounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("F") && !neighbour.getSymbol().equals("I") && !neighbour.getSymbol().equals("Cl") && !neighbour.getSymbol().equals("Br")) continue;
            ++acounter;
        }
        return acounter;
    }

    private int getAtomTypeXCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int nocounter = 0;
        for (IAtom neighbour : neighbours) {
            IBond bond;
            if (!neighbour.getSymbol().equals("N") && !neighbour.getSymbol().equals("O") || ((Boolean)neighbour.getProperty("IS_IN_AROMATIC_RING")).booleanValue() || (bond = ac.getBond(neighbour, atom)).getOrder() == IBond.Order.DOUBLE) continue;
            ++nocounter;
        }
        return nocounter;
    }

    private int getAromaticCarbonsCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int carocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("C") || !neighbour.getFlag(32)) continue;
            ++carocounter;
        }
        return carocounter;
    }

    private int getCarbonsCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int ccounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("C") || neighbour.getFlag(32)) continue;
            ++ccounter;
        }
        return ccounter;
    }

    private int getOxygenCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int ocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("O") || neighbour.getFlag(32)) continue;
            ++ocounter;
        }
        return ocounter;
    }

    private int getDoubleBondedCarbonsCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int cdbcounter = 0;
        for (IAtom neighbour : neighbours) {
            IBond bond;
            if (!neighbour.getSymbol().equals("C") || (bond = ac.getBond(neighbour, atom)).getOrder() != IBond.Order.DOUBLE) continue;
            ++cdbcounter;
        }
        return cdbcounter;
    }

    private int getDoubleBondedOxygenCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int odbcounter = 0;
        boolean chargeFlag = false;
        if (atom.getFormalCharge() >= 1) {
            chargeFlag = true;
        }
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("O")) continue;
            IBond bond = ac.getBond(neighbour, atom);
            if (chargeFlag && neighbour.getFormalCharge() == -1 && bond.getOrder() == IBond.Order.SINGLE) {
                ++odbcounter;
            }
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++odbcounter;
        }
        return odbcounter;
    }

    private int getDoubleBondedSulfurCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int sdbcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("S")) continue;
            if (atom.getFormalCharge() == 1 && neighbour.getFormalCharge() == -1) {
                ++sdbcounter;
            }
            IBond bond = ac.getBond(neighbour, atom);
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++sdbcounter;
        }
        return sdbcounter;
    }

    private int getDoubleBondedNitrogenCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int ndbcounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("N")) continue;
            IBond bond = ac.getBond(neighbour, atom);
            if (neighbour.getFlag(32) || bond.getOrder() != IBond.Order.DOUBLE) continue;
            ++ndbcounter;
        }
        return ndbcounter;
    }

    private int getAromaticNitrogensCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int narocounter = 0;
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("N") || !((Boolean)neighbour.getProperty("IS_IN_AROMATIC_RING")).booleanValue()) continue;
            ++narocounter;
        }
        return narocounter;
    }

    private int getPiSystemsCount(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        int picounter = 0;
        List<IBond> bonds = null;
        for (int i = 0; i < neighbours.size(); ++i) {
            IAtom neighbour = neighbours.get(i);
            bonds = ac.getConnectedBondsList(neighbour);
            for (int j = 0; j < bonds.size(); ++j) {
                IBond bond = bonds.get(j);
                if (bond.getOrder() == IBond.Order.SINGLE || bond.getOther(neighbour).equals(atom) || neighbour.getSymbol().equals("P") || neighbour.getSymbol().equals("S")) continue;
                ++picounter;
            }
        }
        return picounter;
    }

    private boolean getPresenceOfHydroxy(IAtomContainer ac, IAtom atom) {
        IAtom neighbour0 = ac.getConnectedAtomsList(atom).get(0);
        List<IAtom> first = null;
        if (neighbour0.getSymbol().equals("C")) {
            first = ac.getConnectedAtomsList(neighbour0);
            for (int i = 0; i < first.size(); ++i) {
                IAtom conAtom = first.get(i);
                if (!conAtom.getSymbol().equals("O") || ac.getBond(neighbour0, conAtom).getOrder() != IBond.Order.SINGLE) continue;
                return ac.getConnectedBondsCount(conAtom) <= 1 || this.getHydrogenCount(ac, conAtom) != 0;
            }
        }
        return false;
    }

    private boolean getPresenceOfNitro(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        List<IAtom> second = null;
        IBond bond = null;
        for (int i = 0; i < neighbours.size(); ++i) {
            IAtom neighbour = neighbours.get(i);
            if (!neighbour.getSymbol().equals("N")) continue;
            second = ac.getConnectedAtomsList(neighbour);
            for (int b = 0; b < second.size(); ++b) {
                IAtom conAtom = second.get(b);
                if (!conAtom.getSymbol().equals("O") || (bond = ac.getBond(neighbour, conAtom)).getOrder() != IBond.Order.DOUBLE) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getPresenceOfSulfat(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        for (IAtom neighbour : neighbours) {
            if (!neighbour.getSymbol().equals("S") || this.getOxygenCount(ac, neighbour) < 2 || ac.getConnectedBondsCount(neighbour) != 4) continue;
            return true;
        }
        return false;
    }

    private int getPresenceOfCarbonil(IAtomContainer ac, IAtom atom) {
        List<IAtom> neighbours = ac.getConnectedAtomsList(atom);
        List<IAtom> second = null;
        IBond bond = null;
        int counter = 0;
        for (int i = 0; i < neighbours.size(); ++i) {
            IAtom neighbour = neighbours.get(i);
            if (!neighbour.getSymbol().equals("C")) continue;
            second = ac.getConnectedAtomsList(neighbour);
            for (int b = 0; b < second.size(); ++b) {
                IAtom conAtom = second.get(b);
                if (!conAtom.getSymbol().equals("O") || (bond = ac.getBond(neighbour, conAtom)).getOrder() != IBond.Order.DOUBLE) continue;
                ++counter;
            }
        }
        return counter;
    }

    private boolean getIfCarbonIsHydrophobic(IAtomContainer ac, IAtom atom) {
        List<IAtom> first = ac.getConnectedAtomsList(atom);
        List<IAtom> second = null;
        List<IAtom> third = null;
        if (first.size() > 0) {
            for (int i = 0; i < first.size(); ++i) {
                IAtom firstAtom = first.get(i);
                if (!firstAtom.getSymbol().equals("C") && !firstAtom.getSymbol().equals("H")) {
                    return false;
                }
                second = ac.getConnectedAtomsList(firstAtom);
                if (second.size() > 0) {
                    for (int b = 0; b < second.size(); ++b) {
                        IAtom secondAtom = second.get(b);
                        if (!secondAtom.getSymbol().equals("C") && !secondAtom.getSymbol().equals("H")) {
                            return false;
                        }
                        third = ac.getConnectedAtomsList(secondAtom);
                        if (third.size() > 0) {
                            for (int c = 0; c < third.size(); ++c) {
                                IAtom thirdAtom = third.get(c);
                                if (thirdAtom.getSymbol().equals("C") || thirdAtom.getSymbol().equals("H")) continue;
                                return false;
                            }
                            continue;
                        }
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity", "salicylFlag"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }

    private IAtomContainer createPaba(IChemObjectBuilder builder) {
        IAtomContainer container = builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom atom1 = builder.newInstance(IAtom.class, "C");
        container.addAtom(atom1);
        IAtom atom2 = builder.newInstance(IAtom.class, "S");
        container.addAtom(atom2);
        IAtom atom3 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom3);
        IAtom atom4 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom4);
        IAtom atom5 = builder.newInstance(IAtom.class, "C");
        atom5.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom5);
        IAtom atom6 = builder.newInstance(IAtom.class, "C");
        atom6.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom6);
        IAtom atom7 = builder.newInstance(IAtom.class, "C");
        atom7.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom7);
        IAtom atom8 = builder.newInstance(IAtom.class, "C");
        atom8.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom8);
        IAtom atom9 = builder.newInstance(IAtom.class, "N");
        container.addAtom(atom9);
        IAtom atom10 = builder.newInstance(IAtom.class, "C");
        atom10.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom10);
        IAtom atom11 = builder.newInstance(IAtom.class, "C");
        atom11.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom11);
        IBond bond1 = builder.newInstance(IBond.class, new Object[]{atom1, atom2, IBond.Order.SINGLE});
        container.addBond(bond1);
        IBond bond2 = builder.newInstance(IBond.class, new Object[]{atom2, atom3, IBond.Order.DOUBLE});
        container.addBond(bond2);
        IBond bond3 = builder.newInstance(IBond.class, new Object[]{atom2, atom4, IBond.Order.DOUBLE});
        container.addBond(bond3);
        IBond bond4 = builder.newInstance(IBond.class, new Object[]{atom2, atom5, IBond.Order.SINGLE});
        container.addBond(bond4);
        IBond bond5 = builder.newInstance(IBond.class, new Object[]{atom5, atom6, IBond.Order.DOUBLE});
        bond5.setFlag(32, true);
        container.addBond(bond5);
        IBond bond6 = builder.newInstance(IBond.class, new Object[]{atom6, atom7, IBond.Order.SINGLE});
        bond6.setFlag(32, true);
        container.addBond(bond6);
        IBond bond7 = builder.newInstance(IBond.class, new Object[]{atom7, atom8, IBond.Order.DOUBLE});
        bond7.setFlag(32, true);
        container.addBond(bond7);
        IBond bond8 = builder.newInstance(IBond.class, new Object[]{atom8, atom9, IBond.Order.SINGLE});
        container.addBond(bond8);
        IBond bond9 = builder.newInstance(IBond.class, new Object[]{atom8, atom10, IBond.Order.SINGLE});
        bond9.setFlag(32, true);
        container.addBond(bond9);
        IBond bond10 = builder.newInstance(IBond.class, new Object[]{atom10, atom11, IBond.Order.DOUBLE});
        bond10.setFlag(32, true);
        container.addBond(bond10);
        IBond bond11 = builder.newInstance(IBond.class, new Object[]{atom5, atom11, IBond.Order.SINGLE});
        bond11.setFlag(32, true);
        container.addBond(bond11);
        return container;
    }

    private IAtomContainer createAminoAcid(IChemObjectBuilder builder) {
        IAtomContainer container = builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom atom1 = builder.newInstance(IAtom.class, "N");
        container.addAtom(atom1);
        IAtom atom2 = builder.newInstance(IAtom.class, "C");
        container.addAtom(atom2);
        IAtom atom3 = builder.newInstance(IAtom.class, "C");
        container.addAtom(atom3);
        IAtom atom4 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom4);
        IAtom atom5 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom5);
        container.addBond(builder.newInstance(IBond.class, new Object[]{atom1, atom2, IBond.Order.SINGLE}));
        container.addBond(builder.newInstance(IBond.class, new Object[]{atom2, atom3, IBond.Order.SINGLE}));
        container.addBond(builder.newInstance(IBond.class, new Object[]{atom3, atom4, IBond.Order.DOUBLE}));
        container.addBond(builder.newInstance(IBond.class, new Object[]{atom3, atom5, IBond.Order.SINGLE}));
        return container;
    }

    private IAtomContainer createSalicylicAcid(IChemObjectBuilder builder) {
        IAtomContainer container = builder.newInstance(IAtomContainer.class, new Object[0]);
        IAtom atom1 = builder.newInstance(IAtom.class, "C");
        container.addAtom(atom1);
        IAtom atom2 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom2);
        IAtom atom3 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom3);
        IAtom atom4 = builder.newInstance(IAtom.class, "C");
        atom4.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom4);
        IAtom atom5 = builder.newInstance(IAtom.class, "C");
        atom5.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom5);
        IAtom atom6 = builder.newInstance(IAtom.class, "C");
        atom6.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom6);
        IAtom atom7 = builder.newInstance(IAtom.class, "C");
        atom7.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom7);
        IAtom atom8 = builder.newInstance(IAtom.class, "C");
        atom8.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom8);
        IAtom atom9 = builder.newInstance(IAtom.class, "C");
        atom9.setHybridization(IAtomType.Hybridization.SP2);
        container.addAtom(atom9);
        IAtom atom10 = builder.newInstance(IAtom.class, "O");
        container.addAtom(atom10);
        IBond bond1 = builder.newInstance(IBond.class, new Object[]{atom1, atom2, IBond.Order.DOUBLE});
        container.addBond(bond1);
        IBond bond2 = builder.newInstance(IBond.class, new Object[]{atom1, atom3, IBond.Order.SINGLE});
        container.addBond(bond2);
        IBond bond3 = builder.newInstance(IBond.class, new Object[]{atom1, atom4, IBond.Order.SINGLE});
        container.addBond(bond3);
        IBond bond4 = builder.newInstance(IBond.class, new Object[]{atom4, atom5, IBond.Order.DOUBLE});
        bond4.setFlag(32, true);
        container.addBond(bond4);
        IBond bond5 = builder.newInstance(IBond.class, new Object[]{atom5, atom6, IBond.Order.SINGLE});
        bond5.setFlag(32, true);
        container.addBond(bond5);
        IBond bond6 = builder.newInstance(IBond.class, new Object[]{atom6, atom7, IBond.Order.DOUBLE});
        bond6.setFlag(32, true);
        container.addBond(bond6);
        IBond bond7 = builder.newInstance(IBond.class, new Object[]{atom7, atom8, IBond.Order.SINGLE});
        bond7.setFlag(32, true);
        container.addBond(bond7);
        IBond bond8 = builder.newInstance(IBond.class, new Object[]{atom8, atom9, IBond.Order.DOUBLE});
        bond8.setFlag(32, true);
        container.addBond(bond8);
        IBond bond9 = builder.newInstance(IBond.class, new Object[]{atom9, atom4, IBond.Order.SINGLE});
        bond9.setFlag(32, true);
        container.addBond(bond9);
        IBond bond10 = builder.newInstance(IBond.class, new Object[]{atom9, atom10, IBond.Order.SINGLE});
        container.addBond(bond10);
        return container;
    }
}

