/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.viewer.Viewer;

class TempManager {
    Viewer viewer;
    static final int freePointsSize = 6;
    final short[] lengthsFreePoints = new short[6];
    final Point3f[][] freePoints = new Point3f[6][];
    static final int freeScreensSize = 6;
    final short[] lengthsFreeScreens = new short[6];
    final Point3i[][] freeScreens = new Point3i[6][];
    static final int freeBooleansSize = 2;
    final short[] lengthsFreeBooleans = new short[2];
    final boolean[][] freeBooleans = new boolean[2][];

    TempManager(Viewer viewer) {
        this.viewer = viewer;
    }

    static int findBestFit(int size, short[] lengths) {
        int iFit = -1;
        int n = Integer.MAX_VALUE;
        int i = lengths.length;
        while (--i >= 0) {
            short s;
            short freeLength = lengths[i];
            if (freeLength < size || freeLength >= s) continue;
            s = freeLength;
            iFit = i;
        }
        if (iFit >= 0) {
            lengths[iFit] = 0;
        }
        return iFit;
    }

    static int findShorter(int size, short[] lengths) {
        int i = lengths.length;
        while (--i >= 0) {
            if (lengths[i] != 0) continue;
            lengths[i] = (short)size;
            return i;
        }
        int iShortest = 0;
        short shortest = lengths[0];
        int i2 = lengths.length;
        while (--i2 > 0) {
            if (lengths[i2] >= shortest) continue;
            shortest = lengths[i2];
            iShortest = i2;
        }
        if (shortest < size) {
            lengths[iShortest] = (short)size;
            return iShortest;
        }
        return -1;
    }

    Point3f[] allocTempPoints(int size) {
        Point3f[] tempPoints;
        int iFit = TempManager.findBestFit(size, this.lengthsFreePoints);
        if (iFit > 0) {
            tempPoints = this.freePoints[iFit];
        } else {
            tempPoints = new Point3f[size];
            int i = size;
            while (--i >= 0) {
                tempPoints[i] = new Point3f();
            }
        }
        return tempPoints;
    }

    void freeTempPoints(Point3f[] tempPoints) {
        int iFree = TempManager.findShorter(tempPoints.length, this.lengthsFreePoints);
        if (iFree >= 0) {
            this.freePoints[iFree] = tempPoints;
        }
    }

    Point3i[] allocTempScreens(int size) {
        Point3i[] tempScreens;
        int iFit = TempManager.findBestFit(size, this.lengthsFreeScreens);
        if (iFit > 0) {
            tempScreens = this.freeScreens[iFit];
        } else {
            tempScreens = new Point3i[size];
            int i = size;
            while (--i >= 0) {
                tempScreens[i] = new Point3i();
            }
        }
        return tempScreens;
    }

    void freeTempScreens(Point3i[] tempScreens) {
        int iFree = TempManager.findShorter(tempScreens.length, this.lengthsFreeScreens);
        if (iFree >= 0) {
            this.freeScreens[iFree] = tempScreens;
        }
    }

    boolean[] allocTempBooleans(int size) {
        int iFit = TempManager.findBestFit(size, this.lengthsFreeBooleans);
        boolean[] tempBooleans = iFit > 0 ? this.freeBooleans[iFit] : new boolean[size];
        return tempBooleans;
    }

    void freeTempBooleans(boolean[] tempBooleans) {
        int iFree = TempManager.findShorter(tempBooleans.length, this.lengthsFreeBooleans);
        if (iFree >= 0) {
            this.freeBooleans[iFree] = tempBooleans;
        }
    }
}

