/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Circle3D;
import org.jmol.g3d.Colix;
import org.jmol.g3d.Cylinder3D;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Geodesic3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Normix3D;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.Rgb16;
import org.jmol.g3d.Shade3D;
import org.jmol.g3d.Sphere3D;
import org.jmol.g3d.Text3D;
import org.jmol.g3d.Triangle3D;
import org.jmol.util.Logger;

public final class Graphics3D {
    Platform3D platform;
    Line3D line3d;
    Circle3D circle3d;
    Sphere3D sphere3d;
    Triangle3D triangle3d;
    Cylinder3D cylinder3d;
    Hermite3D hermite3d;
    Geodesic3D geodesic3d;
    Normix3D normix3d;
    public static final int HIGHEST_GEODESIC_LEVEL = 3;
    boolean isFullSceneAntialiasingEnabled;
    boolean antialiasThisFrame;
    boolean inGreyscaleMode;
    byte[] anaglyphChannelBytes;
    boolean tPaintingInProgress;
    int windowWidth;
    int windowHeight;
    int width;
    int height;
    int slab;
    int depth;
    int xLast;
    int yLast;
    int[] pbuf;
    int[] zbuf;
    int clipX;
    int clipY;
    int clipWidth;
    int clipHeight;
    short colixCurrent;
    int[] shadesCurrent;
    int argbCurrent;
    boolean isTranslucent;
    int argbNoisyUp;
    int argbNoisyDn;
    Font3D font3dCurrent;
    static final int ZBUFFER_BACKGROUND = Integer.MAX_VALUE;
    int[] imageBuf = new int[0];
    boolean currentlyRendering;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_OPEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    static final boolean ENABLE_GOURAUD_STATS = false;
    static int totalGouraud;
    static int shortCircuitGouraud;
    static final short TRANSLUCENT_MASK = 16384;
    static final short OPAQUE_MASK = -16385;
    static final short CHANGABLE_MASK = Short.MIN_VALUE;
    static final short UNMASK_CHANGABLE_TRANSLUCENT = 16383;
    public static final short NULL_COLIX = 0;
    public static final short TRANSLUCENT = 1;
    public static final short OPAQUE = 2;
    public static final short UNRECOGNIZED = 3;
    public static final short SPECIAL_COLIX_MAX = 4;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;
    static int[] predefinedArgbs;
    short[] changableColixMap = new short[16];
    public static final byte shadeMax = 64;
    public static final byte shadeLast = 63;
    public static final byte shadeNormal;
    public static final byte intensitySpecularSurfaceLimit;
    private final Vector3f vectorAB = new Vector3f();
    private final Vector3f vectorAC = new Vector3f();
    private final Vector3f vectorNormal = new Vector3f();
    public static final String[] colorNames;
    public static final int[] colorArgbs;
    private static final Hashtable mapJavaScriptColors;
    public static final int GEODESIC_START_VERTEX_COUNT = 12;
    public static final int GEODESIC_START_NEIGHBOR_COUNT = 5;

    public Graphics3D(Component awtComponent) {
        this.platform = Platform3D.createInstance(awtComponent);
        this.line3d = new Line3D(this);
        this.circle3d = new Circle3D(this);
        this.sphere3d = new Sphere3D(this);
        this.triangle3d = new Triangle3D(this);
        this.cylinder3d = new Cylinder3D(this);
        this.hermite3d = new Hermite3D(this);
        this.geodesic3d = new Geodesic3D(this);
        this.normix3d = new Normix3D(this);
    }

    public void setWindowSize(int windowWidth, int windowHeight, boolean enableFullSceneAntialiasing) {
        if (this.windowWidth == windowWidth && this.windowHeight == windowHeight && enableFullSceneAntialiasing == this.isFullSceneAntialiasingEnabled) {
            return;
        }
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.isFullSceneAntialiasingEnabled = enableFullSceneAntialiasing;
        this.width = -1;
        this.height = -1;
        this.pbuf = null;
        this.zbuf = null;
        this.platform.releaseBuffers();
    }

    public boolean fullSceneAntialiasRendering() {
        return false;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    public int getSlab() {
        return this.slab;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setBackgroundArgb(int argb) {
        this.platform.setBackground(argb);
    }

    public void setGreyscaleMode(boolean greyscaleMode) {
        this.inGreyscaleMode = greyscaleMode;
    }

    public void setSlabAndDepthValues(int slabValue, int depthValue) {
        int n = slabValue < 0 ? 0 : (this.slab = slabValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : slabValue);
        this.depth = depthValue < 0 ? 0 : (depthValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : depthValue);
    }

    private void downSampleFullSceneAntialiasing() {
        int[] pbuf1 = this.pbuf;
        int[] pbuf4 = this.pbuf;
        int width4 = this.width;
        int offset1 = 0;
        int offset4 = 0;
        int i = this.windowHeight;
        while (--i >= 0) {
            int j = this.windowWidth;
            while (--j >= 0) {
                int argb = pbuf4[offset4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[offset4 + width4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[++offset4] >> 2 & 0x3F3F3F3F;
                argb += pbuf4[offset4 + width4] >> 2 & 0x3F3F3F3F;
                argb += (argb & 0xC0C0C0C0) >> 6;
                pbuf1[offset1] = argb |= 0xFF000000;
                ++offset1;
                ++offset4;
            }
            offset4 += width4;
        }
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    public void setColix(short colix) {
        this.colixCurrent = colix;
        this.shadesCurrent = this.getShades(colix);
        this.argbNoisyUp = this.argbNoisyDn = this.getColixArgb(colix);
        this.argbCurrent = this.argbNoisyDn;
        this.isTranslucent = (colix & 0x4000) != 0;
    }

    public void setColixIntensity(short colix, int intensity) {
        this.colixCurrent = colix;
        this.shadesCurrent = this.getShades(colix);
        this.argbNoisyUp = this.argbNoisyDn = this.shadesCurrent[intensity];
        this.argbCurrent = this.argbNoisyDn;
        this.isTranslucent = (colix & 0x4000) != 0;
    }

    public void setIntensity(int intensity) {
        this.argbNoisyUp = this.argbNoisyDn = this.shadesCurrent[intensity];
        this.argbCurrent = this.argbNoisyDn;
    }

    void setColorNoisy(short colix, int intensity) {
        this.colixCurrent = colix;
        int[] shades = this.getShades(colix);
        this.argbCurrent = shades[intensity];
        this.argbNoisyUp = shades[intensity < 63 ? intensity + 1 : 63];
        this.argbNoisyDn = shades[intensity > 0 ? intensity - 1 : 0];
        this.isTranslucent = (colix & 0x4000) != 0;
    }

    public void fillScreenedCircleCentered(short colixFill, int diameter, int x, int y, int z) {
        if (this.isClippedZ(z)) {
            return;
        }
        int r = (diameter + 1) / 2;
        this.setColix(colixFill);
        this.isTranslucent = true;
        if (x >= r && x + r < this.width && y >= r && y + r < this.height) {
            this.circle3d.plotFilledCircleCenteredUnclipped(x, y, z, diameter);
            this.isTranslucent = false;
            this.circle3d.plotCircleCenteredUnclipped(x, y, z, diameter);
        } else if (!this.isClippedXY(diameter, x, y)) {
            this.circle3d.plotFilledCircleCenteredClipped(x, y, z, diameter);
            this.isTranslucent = false;
            this.circle3d.plotCircleCenteredClipped(x, y, z, diameter);
        }
    }

    public void fillSphereCentered(short colix, int diameter, int x, int y, int z) {
        if (diameter <= 1) {
            this.plotPixelClipped(this.getColixArgb(colix), x, y, z);
        } else {
            this.sphere3d.render(this.getShades(colix), (colix & 0x4000) != 0, diameter, x, y, z);
        }
    }

    public void fillSphereCentered(short colix, int diameter, Point3i center) {
        this.fillSphereCentered(colix, diameter, center.x, center.y, center.z);
    }

    public void fillSphereCentered(short colix, int diameter, Point3f center) {
        this.fillSphereCentered(colix, diameter, (int)center.x, (int)center.y, (int)center.z);
    }

    public void drawRect(short colix, int x, int y, int z, int zSlab, int rWidth, int rHeight) {
        if (this.isClippedZ(zSlab)) {
            return;
        }
        int w = rWidth - 1;
        int h = rHeight - 1;
        int xRight = x + w;
        int yBottom = y + h;
        this.setColix(colix);
        if (y >= 0 && y < this.height) {
            this.line3d.drawHLine(this.argbCurrent, this.isTranslucent, x, y, z, w);
        }
        if (yBottom >= 0 && yBottom < this.height) {
            this.line3d.drawHLine(this.argbCurrent, this.isTranslucent, x, yBottom, z, w);
        }
        if (x >= 0 && x < this.width) {
            this.line3d.drawVLine(this.argbCurrent, this.isTranslucent, x, y, z, h);
        }
        if (xRight >= 0 && xRight < this.width) {
            this.line3d.drawVLine(this.argbCurrent, this.isTranslucent, xRight, y, z, h);
        }
    }

    public void fillRect(short colix, int x, int y, int z, int zSlab, int widthFill, int heightFill) {
        if (this.isClippedZ(zSlab)) {
            return;
        }
        if (x < 0) {
            if ((widthFill += x) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + widthFill > this.width && (widthFill = this.width - x) <= 0) {
            return;
        }
        if (y < 0) {
            if ((heightFill += y) <= 0) {
                return;
            }
            y = 0;
        }
        this.setColix(colix);
        if (y + heightFill > this.height) {
            heightFill = this.height - y;
        }
        while (--heightFill >= 0) {
            this.plotPixelsUnclipped(widthFill, x, y++, z);
        }
    }

    public void drawString(String str, Font3D font3d, short colix, int xBaseline, int yBaseline, int z, int zSlab) {
        if (str == null) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.drawStringNoSlab(str, font3d, colix, (short)0, xBaseline, yBaseline, z);
    }

    public void drawStringNoSlab(String str, Font3D font3d, short colix, short bgcolix, int xBaseline, int yBaseline, int z) {
        if (str == null) {
            return;
        }
        if (font3d != null) {
            this.font3dCurrent = font3d;
        }
        this.setColix(colix);
        Text3D.plot(xBaseline, yBaseline - this.font3dCurrent.fontMetrics.getAscent(), z, this.argbCurrent, this.getColixArgb(bgcolix), str, this.font3dCurrent, this);
    }

    public void setFontOfSize(int fontsize) {
        this.font3dCurrent = this.getFont3D(fontsize);
    }

    public void setFont(byte fid) {
        this.font3dCurrent = Font3D.getFont3D(fid);
    }

    public void setFont(Font3D font3d) {
        this.font3dCurrent = font3d;
    }

    public Font3D getFont3DCurrent() {
        return this.font3dCurrent;
    }

    public byte getFontFidCurrent() {
        return this.font3dCurrent.fid;
    }

    public FontMetrics getFontMetrics() {
        return this.font3dCurrent.fontMetrics;
    }

    private void setRectClip(int x, int y, int width, int height) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > this.windowWidth) {
            width = this.windowWidth - x;
        }
        if (y + height > this.windowHeight) {
            height = this.windowHeight - y;
        }
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        if (this.antialiasThisFrame) {
            this.clipX *= 2;
            this.clipY *= 2;
            this.clipWidth *= 2;
            this.clipHeight *= 2;
        }
    }

    public void beginRendering(int clipX, int clipY, int clipWidth, int clipHeight, Matrix3f rotationMatrix, boolean antialiasThisFrame) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        this.normix3d.setRotationMatrix(rotationMatrix);
        this.antialiasThisFrame = antialiasThisFrame &= this.isFullSceneAntialiasingEnabled;
        this.currentlyRendering = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.isFullSceneAntialiasingEnabled);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
            this.width = this.windowWidth;
            this.xLast = this.width - 1;
            this.height = this.windowHeight;
            this.yLast = this.height - 1;
        }
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (antialiasThisFrame) {
            this.width *= 2;
            this.height *= 2;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.setRectClip(clipX, clipY, clipWidth, clipHeight);
        this.platform.obtainScreenBuffer();
    }

    public void endRendering() {
        if (this.currentlyRendering) {
            if (this.antialiasThisFrame) {
                this.downSampleFullSceneAntialiasing();
            }
            this.platform.notifyEndOfRendering();
            this.currentlyRendering = false;
        }
    }

    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.pbuf.length) {
            this.anaglyphChannelBytes = new byte[this.pbuf.length];
        }
        int i = this.pbuf.length;
        while (--i >= 0) {
            this.anaglyphChannelBytes[i] = (byte)this.pbuf[i];
        }
    }

    public void applyCustomAnaglyph(int[] stereoColors) {
        int color1 = stereoColors[0];
        int color2 = stereoColors[1] & 0xFFFFFF;
        int i = this.pbuf.length;
        while (--i >= 0) {
            int a = this.anaglyphChannelBytes[i] & 0xFF;
            a = (a | (a | a << 8) << 8) & color2;
            this.pbuf[i] = this.pbuf[i] & color1 | a;
        }
    }

    public void applyGreenAnaglyph() {
        int i = this.pbuf.length;
        while (--i >= 0) {
            int green = (this.anaglyphChannelBytes[i] & 0xFF) << 8;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | green;
        }
    }

    public void applyBlueAnaglyph() {
        int i = this.pbuf.length;
        while (--i >= 0) {
            int blue = this.anaglyphChannelBytes[i] & 0xFF;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | blue;
        }
    }

    public void applyCyanAnaglyph() {
        int i = this.pbuf.length;
        while (--i >= 0) {
            int blue = this.anaglyphChannelBytes[i] & 0xFF;
            int cyan = blue << 8 | blue;
            this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | cyan;
        }
    }

    public Image getScreenImage() {
        return this.platform.imagePixelBuffer;
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public void drawPixel(int x, int y, int z) {
        this.plotPixelClipped(x, y, z);
    }

    public void drawPoints(short colix, int count, int[] coordinates) {
        this.setColix(colix);
        this.plotPoints(count, coordinates);
    }

    public void drawDashedLine(short colix, int run, int rise, int x1, int y1, int z1, int x2, int y2, int z2) {
        int argb = this.getColixArgb(colix);
        this.line3d.plotDashedLine(argb, this.isTranslucent, argb, this.isTranslucent, run, rise, x1, y1, z1, x2, y2, z2, false);
    }

    public void drawDottedLine(short colix, Point3i pointA, Point3i pointB) {
        this.setColix(colix);
        this.line3d.plotDashedLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, 2, 1, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z, false);
    }

    public void drawLine(short colix, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.setColix(colix);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, x1, y1, z1, x2, y2, z2, false);
    }

    public void drawLine(short colix1, short colix2, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.plotLine(this.getColixArgb(colix1), Graphics3D.isColixTranslucent(colix1), this.getColixArgb(colix2), Graphics3D.isColixTranslucent(colix2), x1, y1, z1, x2, y2, z2, false);
    }

    void drawLine(Point3i pointA, Point3i pointB) {
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, pointA.x, pointA.y, pointA.z, pointB.x, pointB.y, pointB.z, false);
    }

    public void fillCylinder(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.render(colixA, colixB, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.render(colix, colix, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinder(short colix, byte endcaps, int diameter, Point3i screenA, Point3i screenB) {
        this.cylinder3d.render(colix, colix, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
    }

    public void fillCylinderBits(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        this.cylinder3d.renderBits(colixA, colixB, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    public void fillCylinderBits(short colix, byte endcaps, int diameter, Point3i screenA, Point3i screenB) {
        this.cylinder3d.renderBits(colix, colix, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
    }

    public void fillCylinderBits(short colix, byte endcaps, int diameter, Point3f screenA, Point3f screenB) {
        this.cylinder3d.renderBits(colix, colix, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3i screenBase, Point3i screenTip) {
        this.cylinder3d.renderCone(colix, endcap, diameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z);
    }

    public void fillCone(short colix, byte endcap, int diameter, Point3f screenBase, Point3f screenTip) {
        this.cylinder3d.renderCone(colix, endcap, diameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z);
    }

    public void drawHermite(short colix, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(false, colix, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    public void drawHermite(boolean fill, boolean border, short colix, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3, Point3i s4, Point3i s5, Point3i s6, Point3i s7) {
        this.hermite3d.render2(fill, border, colix, tension, s0, s1, s2, s3, s4, s5, s6, s7, 0);
    }

    public void drawHermite(boolean fill, boolean border, short colix, int tension, Point3i s0, Point3i s1, Point3i s2, Point3i s3, Point3i s4, Point3i s5, Point3i s6, Point3i s7, int aspectRatio) {
        this.hermite3d.render2(fill, border, colix, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio);
    }

    public void fillHermite(short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3i s0, Point3i s1, Point3i s2, Point3i s3) {
        this.hermite3d.render(true, colix, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    public void drawTriangle(short colix, Point3i screenA, Point3i screenB, Point3i screenC) {
        this.drawTriangle(colix, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z, screenC.x, screenC.y, screenC.z, false);
    }

    void drawTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC, boolean notClipped) {
        this.setColix(colix);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xA, yA, zA, xB, yB, zB, notClipped);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xA, yA, zA, xC, yC, zC, notClipped);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xB, yB, zB, xC, yC, zC, notClipped);
    }

    public void drawCylinderTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC, int diameter) {
        this.fillCylinder(colix, colix, (byte)3, diameter, xA, yA, zA, xB, yB, zB);
        this.fillCylinder(colix, colix, (byte)3, diameter, xA, yA, zA, xC, yC, zC);
        this.fillCylinder(colix, colix, (byte)3, diameter, xB, yB, zB, xC, yC, zC);
    }

    public void drawfillTriangle(short colix, int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC) {
        this.setColix(colix);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xA, yA, zA, xB, yB, zB, false);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xA, yA, zA, xC, yC, zC, false);
        this.line3d.plotLine(this.argbCurrent, this.isTranslucent, this.argbCurrent, this.isTranslucent, xB, yB, zB, xC, yC, zC, false);
        this.triangle3d.fillTriangle(xA, yA, zA, xB, yB, zB, xC, yC, zC, false);
    }

    public void fillTriangle(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC) {
        boolean useGouraud;
        if (normixA == normixB && normixA == normixC && colixA == colixB && colixA == colixC) {
            this.setColorNoisy(colixA, this.normix3d.getIntensity(normixA));
            useGouraud = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(colixA)[this.normix3d.getIntensity(normixA)], this.getShades(colixB)[this.normix3d.getIntensity(normixB)], this.getShades(colixC)[this.normix3d.getIntensity(normixC)]);
            int translucentCount = 0;
            if (Graphics3D.isColixTranslucent(colixA)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixB)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixC)) {
                ++translucentCount;
            }
            this.isTranslucent = translucentCount >= 2;
            useGouraud = true;
        }
        this.triangle3d.fillTriangle(screenA, screenB, screenC, useGouraud);
    }

    public void fillTriangle(short colix, Point3i screenA, Point3i screenB, Point3i screenC) {
        this.calcSurfaceShade(colix, screenA, screenB, screenC);
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
    }

    public void fillTriangle(short colix, short normix, int xScreenA, int yScreenA, int zScreenA, int xScreenB, int yScreenB, int zScreenB, int xScreenC, int yScreenC, int zScreenC) {
        this.setColorNoisy(colix, this.normix3d.getIntensity(normix));
        this.triangle3d.fillTriangle(xScreenA, yScreenA, zScreenA, xScreenB, yScreenB, zScreenB, xScreenC, yScreenC, zScreenC, false);
    }

    public void fillTriangle(short colix, Point3f screenA, Point3f screenB, Point3f screenC) {
        this.setColorNoisy(colix, this.calcIntensityScreen(screenA, screenB, screenC));
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
    }

    public void fillTriangle(Point3i screenA, Point3i screenB, Point3i screenC) {
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
    }

    public void fillTriangle(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC, float factor) {
        boolean useGouraud;
        if (normixA == normixB && normixA == normixC && colixA == colixB && colixA == colixC) {
            this.setColorNoisy(colixA, this.normix3d.getIntensity(normixA));
            useGouraud = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(colixA)[this.normix3d.getIntensity(normixA)], this.getShades(colixB)[this.normix3d.getIntensity(normixB)], this.getShades(colixC)[this.normix3d.getIntensity(normixC)]);
            int translucentCount = 0;
            if (Graphics3D.isColixTranslucent(colixA)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixB)) {
                ++translucentCount;
            }
            if (Graphics3D.isColixTranslucent(colixC)) {
                ++translucentCount;
            }
            this.isTranslucent = translucentCount >= 2;
            useGouraud = true;
        }
        this.triangle3d.fillTriangle(screenA, screenB, screenC, factor, useGouraud);
    }

    public void drawQuadrilateral(short colix, Point3i screenA, Point3i screenB, Point3i screenC, Point3i screenD) {
        this.setColix(colix);
        this.drawLine(screenA, screenB);
        this.drawLine(screenB, screenC);
        this.drawLine(screenC, screenD);
        this.drawLine(screenD, screenA);
    }

    public void fillQuadrilateral(short colix, Point3f screenA, Point3f screenB, Point3f screenC, Point3f screenD) {
        this.setColorNoisy(colix, this.calcIntensityScreen(screenA, screenB, screenC));
        this.triangle3d.fillTriangle(screenA, screenB, screenC, false);
        this.triangle3d.fillTriangle(screenA, screenC, screenD, false);
    }

    public void fillQuadrilateral(Point3i screenA, short colixA, short normixA, Point3i screenB, short colixB, short normixB, Point3i screenC, short colixC, short normixC, Point3i screenD, short colixD, short normixD) {
        this.fillTriangle(screenA, colixA, normixA, screenB, colixB, normixB, screenC, colixC, normixC);
        this.fillTriangle(screenA, colixA, normixA, screenC, colixC, normixC, screenD, colixD, normixD);
    }

    private boolean isClipped(int x, int y, int z) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth;
    }

    private boolean isClipped(int x, int y) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height;
    }

    private boolean isClippedXY(int diameter, int x, int y) {
        int r = diameter + 1 >> 1;
        return x < -r || x >= this.width + r || y < -r || y >= this.height + r;
    }

    public boolean isClippedZ(int z) {
        return z != Integer.MIN_VALUE && (z < this.slab || z > this.depth);
    }

    void plotPixelClipped(int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = this.argbCurrent;
        }
    }

    void plotPixelClipped(Point3i screen) {
        this.plotPixelClipped(screen.x, screen.y, screen.z);
    }

    void plotPixelClipped(int argb, int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelClippedNoSlab(int argb, int x, int y, int z) {
        if (this.isClipped(x, y)) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelClipped(int argb, boolean isTranslucent, int x, int y, int z) {
        if (this.isClipped(x, y, z)) {
            return;
        }
        if (isTranslucent && ((x ^ y) & 1) != 0) {
            return;
        }
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelUnclipped(int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = this.argbCurrent;
        }
    }

    void plotPixelUnclipped(int argb, int x, int y, int z) {
        int offset = y * this.width + x;
        if (z < this.zbuf[offset]) {
            this.zbuf[offset] = z;
            this.pbuf[offset] = argb;
        }
    }

    void plotPixelsClipped(int count, int x, int y, int z) {
        if (y < 0 || y >= this.height || x >= this.width) {
            return;
        }
        if (x < 0) {
            count += x;
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        if (count <= 0) {
            return;
        }
        int offsetPbuf = y * this.width + x;
        int offsetMax = offsetPbuf + count;
        int step = 1;
        if (this.isTranslucent) {
            step = 2;
            if (((x ^ y) & 1) != 0) {
                ++offsetPbuf;
            }
        }
        while (offsetPbuf < offsetMax) {
            if (z < this.zbuf[offsetPbuf]) {
                this.zbuf[offsetPbuf] = z;
                this.pbuf[offsetPbuf] = this.argbCurrent;
            }
            offsetPbuf += step;
        }
    }

    void plotPixelsClipped(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        if (count <= 0 || y < 0 || y >= this.height || x >= this.width || zAtLeft < this.slab && zPastRight < this.slab || zAtLeft > this.depth && zPastRight > this.depth) {
            return;
        }
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = ((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count;
        if (x < 0) {
            x = -x;
            zScaled += zIncrementScaled * x;
            if ((count -= x) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        int offsetPbuf = y * this.width + x;
        if (rgb16Left == null) {
            while (--count >= 0) {
                int z;
                if ((!this.isTranslucent || (flipflop = !flipflop)) && (z = zScaled >> 10) >= this.slab && z <= this.depth && z < this.zbuf[offsetPbuf]) {
                    this.zbuf[offsetPbuf] = z;
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    this.pbuf[offsetPbuf] = bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent);
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
            }
        } else {
            int rScaled = rgb16Left.rScaled << 8;
            int rIncrement = (rgb16Right.rScaled - rgb16Left.rScaled << 8) / count;
            int gScaled = rgb16Left.gScaled;
            int gIncrement = (rgb16Right.gScaled - gScaled) / count;
            int bScaled = rgb16Left.bScaled;
            int bIncrement = (rgb16Right.bScaled - bScaled) / count;
            while (--count >= 0) {
                int z;
                if ((!this.isTranslucent || (flipflop = !flipflop)) && (z = zScaled >> 10) >= this.slab && z <= this.depth && z < this.zbuf[offsetPbuf]) {
                    this.zbuf[offsetPbuf] = z;
                    this.pbuf[offsetPbuf] = 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF;
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclipped(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        if (count <= 0) {
            return;
        }
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = ((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count;
        int offsetPbuf = y * this.width + x;
        if (rgb16Left == null) {
            if (!this.isTranslucent) {
                while (--count >= 0) {
                    int z = zScaled >> 10;
                    if (z < this.zbuf[offsetPbuf]) {
                        this.zbuf[offsetPbuf] = z;
                        int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                        this.pbuf[offsetPbuf] = bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent);
                    }
                    ++offsetPbuf;
                    zScaled += zIncrementScaled;
                }
            } else {
                boolean flipflop;
                boolean bl = flipflop = ((x ^ y) & 1) != 0;
                while (--count >= 0) {
                    int z;
                    boolean bl2 = flipflop = !flipflop;
                    if (flipflop && (z = zScaled >> 10) < this.zbuf[offsetPbuf]) {
                        this.zbuf[offsetPbuf] = z;
                        int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                        this.pbuf[offsetPbuf] = bits == 0 ? this.argbNoisyDn : (bits == 1 ? this.argbNoisyUp : this.argbCurrent);
                    }
                    ++offsetPbuf;
                    zScaled += zIncrementScaled;
                }
            }
        } else {
            boolean flipflop = ((x ^ y) & 1) != 0;
            int rScaled = rgb16Left.rScaled << 8;
            int rIncrement = (rgb16Right.rScaled - rgb16Left.rScaled << 8) / count;
            int gScaled = rgb16Left.gScaled;
            int gIncrement = (rgb16Right.gScaled - gScaled) / count;
            int bScaled = rgb16Left.bScaled;
            int bIncrement = (rgb16Right.bScaled - bScaled) / count;
            while (--count >= 0) {
                int z;
                if ((!this.isTranslucent || (flipflop = !flipflop)) && (z = zScaled >> 10) < this.zbuf[offsetPbuf]) {
                    this.zbuf[offsetPbuf] = z;
                    this.pbuf[offsetPbuf] = 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF;
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclipped(int count, int x, int y, int z) {
        int offsetPbuf = y * this.width + x;
        if (!this.isTranslucent) {
            while (--count >= 0) {
                if (z < this.zbuf[offsetPbuf]) {
                    this.zbuf[offsetPbuf] = z;
                    this.pbuf[offsetPbuf] = this.argbCurrent;
                }
                ++offsetPbuf;
            }
        } else {
            int offsetMax = offsetPbuf + count;
            if (((x ^ y) & 1) != 0 && ++offsetPbuf == offsetMax) {
                return;
            }
            do {
                if (z >= this.zbuf[offsetPbuf]) continue;
                this.zbuf[offsetPbuf] = z;
                this.pbuf[offsetPbuf] = this.argbCurrent;
            } while ((offsetPbuf += 2) < offsetMax);
        }
    }

    void plotPoints(int count, int[] coordinates) {
        int argb = this.argbCurrent;
        int i = count * 3;
        while (i > 0) {
            int offset;
            int y;
            int x;
            int z = coordinates[--i];
            --i;
            if (this.isClipped(x = coordinates[--i], y = coordinates[i], z) || z >= this.zbuf[offset = y * this.width + x]) continue;
            this.zbuf[offset] = z;
            this.pbuf[offset] = argb;
        }
    }

    public static int calcGreyscaleRgbFromRgb(int rgb) {
        int grey = (2989 * (rgb >> 16 & 0xFF) + 5870 * (rgb >> 8 & 0xFF) + 1140 * (rgb & 0xFF) + 5000) / 10000;
        int greyRgb = grey << 16 | grey << 8 | grey | 0xFF000000;
        return greyRgb;
    }

    public int getColixArgb(short colix) {
        if (colix < 0) {
            colix = this.changableColixMap[colix & 0x3FFF];
        }
        if (!this.inGreyscaleMode) {
            return Colix.getArgb(colix);
        }
        return Colix.getArgbGreyscale(colix);
    }

    public int[] getShades(short colix) {
        if (colix < 0) {
            colix = this.changableColixMap[colix & 0x3FFF];
        }
        if (!this.inGreyscaleMode) {
            return Colix.getShades(colix);
        }
        return Colix.getShadesGreyscale(colix);
    }

    public static final short getChangableColixIndex(short colix) {
        if (colix >= 0) {
            return -1;
        }
        return (short)(colix & 0x3FFF);
    }

    public static final boolean isColixTranslucent(short colix) {
        return (colix & 0x4000) != 0;
    }

    public static final short getTranslucentColix(short colix, boolean translucent) {
        return (short)(translucent ? colix | 0x4000 : colix & 0xFFFFBFFF);
    }

    public static final short getTranslucentColix(short colix) {
        return (short)(colix | 0x4000);
    }

    public static final short getOpaqueColix(short colix) {
        return (short)(colix & 0xFFFFBFFF);
    }

    public static final short getColix(int argb) {
        return Colix.getColix(argb);
    }

    public final short getColixMix(short colixA, short colixB) {
        return Colix.getColixMix(colixA >= 0 ? colixA : this.changableColixMap[colixA & 0x3FFF], colixB >= 0 ? colixB : this.changableColixMap[colixB & 0x3FFF]);
    }

    public static final short setTranslucent(short colix, boolean isTranslucent) {
        if (isTranslucent) {
            if (colix >= 0 && colix < 4) {
                return 1;
            }
            return (short)(colix | 0x4000);
        }
        if (colix >= 0 && colix < 4) {
            return 2;
        }
        return (short)(colix & 0xFFFFBFFF);
    }

    public static final short getColix(String colorName) {
        int argb = Graphics3D.getArgbFromString(colorName);
        if (argb != 0) {
            return Graphics3D.getColix(argb);
        }
        if ("none".equalsIgnoreCase(colorName)) {
            return 0;
        }
        if ("translucent".equalsIgnoreCase(colorName)) {
            return 1;
        }
        if ("opaque".equalsIgnoreCase(colorName)) {
            return 2;
        }
        return 3;
    }

    public static final short getColix(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return Graphics3D.getColix((Integer)obj);
        }
        if (obj instanceof String) {
            return Graphics3D.getColix((String)obj);
        }
        Logger.debug("?? getColix(" + obj + ")");
        return 22;
    }

    public static final short inheritColix(short myColix, short parentColix) {
        switch (myColix) {
            case 0: {
                return parentColix;
            }
            case 1: {
                return (short)(parentColix | 0x4000);
            }
            case 2: {
                return (short)(parentColix & 0xFFFFBFFF);
            }
        }
        return myColix;
    }

    public static final short inheritColix(short myColix, short parentColix, short grandParentColix) {
        if (myColix >= 4) {
            return myColix;
        }
        parentColix = Graphics3D.inheritColix(parentColix, grandParentColix);
        if (myColix == 0) {
            return parentColix;
        }
        return Graphics3D.inheritColix(myColix, parentColix);
    }

    public String getHexColorFromIndex(short colix) {
        int argb = this.getColixArgb(colix);
        return this.getHexColorFromRGB(argb);
    }

    public String getHexColorFromRGB(int argb) {
        if (argb == 0) {
            return null;
        }
        String r = "00" + Integer.toHexString(argb >> 16 & 0xFF);
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(argb >> 8 & 0xFF);
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(argb & 0xFF);
        b = b.substring(b.length() - 2);
        return "#" + r + g + b;
    }

    public short getChangableColix(short id, int argb) {
        if (id >= this.changableColixMap.length) {
            short[] t = new short[id + 16];
            System.arraycopy(this.changableColixMap, 0, t, 0, this.changableColixMap.length);
            this.changableColixMap = t;
        }
        if (this.changableColixMap[id] == 0) {
            this.changableColixMap[id] = Graphics3D.getColix(argb);
        }
        return (short)(id | Short.MIN_VALUE);
    }

    public void changeColixArgb(short id, int argb) {
        if (id < this.changableColixMap.length && this.changableColixMap[id] != 0) {
            this.changableColixMap[id] = Graphics3D.getColix(argb);
        }
    }

    public void flushShadesAndImageCaches() {
        Colix.flushShades();
        Sphere3D.flushImageCache();
    }

    public void setSpecular(boolean specular) {
        Shade3D.setSpecular(specular);
    }

    public boolean getSpecular() {
        return Shade3D.getSpecular();
    }

    public void setSpecularPower(int specularPower) {
        Shade3D.setSpecularPower(specularPower);
    }

    public void setAmbientPercent(int ambientPercent) {
        Shade3D.setAmbientPercent(ambientPercent);
    }

    public void setDiffusePercent(int diffusePercent) {
        Shade3D.setDiffusePercent(diffusePercent);
    }

    public void setSpecularPercent(int specularPercent) {
        Shade3D.setSpecularPercent(specularPercent);
    }

    public void setLightsourceZ(float dist) {
        Shade3D.setLightsourceZ(dist);
    }

    public void calcSurfaceShade(short colix, Point3i screenA, Point3i screenB, Point3i screenC) {
        int intensity;
        this.vectorAB.x = screenB.x - screenA.x;
        this.vectorAB.y = screenB.y - screenA.y;
        this.vectorAB.z = screenB.z - screenA.z;
        this.vectorAC.x = screenC.x - screenA.x;
        this.vectorAC.y = screenC.y - screenA.y;
        this.vectorAC.z = screenC.z - screenA.z;
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        int n = intensity = this.vectorNormal.z >= 0.0f ? Graphics3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Graphics3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
        if (intensity > intensitySpecularSurfaceLimit) {
            intensity = intensitySpecularSurfaceLimit;
        }
        this.setColorNoisy(colix, intensity);
    }

    public int calcIntensityScreen(Point3f screenA, Point3f screenB, Point3f screenC) {
        this.vectorAB.sub(screenB, screenA);
        this.vectorAC.sub(screenC, screenA);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        return this.vectorNormal.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Shade3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
    }

    public static int calcIntensity(float x, float y, float z) {
        return Shade3D.calcIntensity(x, y, z);
    }

    public Font3D getFont3D(int fontSize) {
        return Font3D.getFont3D(0, 0, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, int fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), 0, fontSize, this.platform);
    }

    public Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return Font3D.getFont3D(Font3D.getFontFaceID(fontFace), Font3D.getFontStyleID(fontStyle), fontSize, this.platform);
    }

    public byte getFontFid(int fontSize) {
        return this.getFont3D((int)fontSize).fid;
    }

    public byte getFontFid(String fontFace, int fontSize) {
        return this.getFont3D((String)fontFace, (int)fontSize).fid;
    }

    public byte getFontFid(String fontFace, String fontStyle, int fontSize) {
        return this.getFont3D((String)fontFace, (String)fontStyle, (int)fontSize).fid;
    }

    public static int getArgbFromString(String strColor) {
        if (strColor != null) {
            if (strColor.length() == 7 && strColor.charAt(0) == '#') {
                try {
                    int red = Integer.parseInt(strColor.substring(1, 3), 16);
                    int grn = Integer.parseInt(strColor.substring(3, 5), 16);
                    int blu = Integer.parseInt(strColor.substring(5, 7), 16);
                    return 0xFF000000 | (red & 0xFF) << 16 | (grn & 0xFF) << 8 | blu & 0xFF;
                }
                catch (NumberFormatException e) {}
            } else {
                Integer boxedArgb = (Integer)mapJavaScriptColors.get(strColor.toLowerCase());
                if (boxedArgb != null) {
                    return boxedArgb;
                }
            }
        }
        return 0;
    }

    public static void calcNormalizedNormal(Point3f pointA, Point3f pointB, Point3f pointC, Vector3f vNormNorm, Vector3f vAB, Vector3f vAC) {
        vAB.sub(pointB, pointA);
        vAC.sub(pointC, pointA);
        vNormNorm.cross(vAB, vAC);
        vNormNorm.normalize();
    }

    public static float getPlaneThroughPoints(Point3f pointA, Point3f pointB, Point3f pointC, Vector3f vNorm, Vector3f vAB, Vector3f vAC) {
        Graphics3D.calcNormalizedNormal(pointA, pointB, pointC, vNorm, vAB, vAC);
        vAB.set(pointA);
        float d = -vAB.dot(vNorm);
        return d;
    }

    public static void getNormalFromCenter(Point3f ptCenter, Point3f ptA, Point3f ptB, Point3f ptC, boolean isOutward, Vector3f normal) {
        boolean doReverse;
        Point3f ptT = new Point3f();
        Point3f ptT2 = new Point3f();
        Vector3f vAB = new Vector3f();
        Vector3f vAC = new Vector3f();
        Graphics3D.calcNormalizedNormal(ptA, ptB, ptC, normal, vAB, vAC);
        ptT.set(ptA);
        ptT.add(ptB);
        ptT.add(ptC);
        ptT.scale(0.33333334f);
        ptT2.set(normal);
        ptT2.scale(0.1f);
        ptT2.add(ptT);
        boolean bl = doReverse = isOutward && ptCenter.distance(ptT2) < ptCenter.distance(ptT) || !isOutward && ptCenter.distance(ptT) < ptCenter.distance(ptT2);
        if (doReverse) {
            normal.scale(-1.0f);
        }
    }

    public void calcXYNormalToLine(Point3f pointA, Point3f pointB, Vector3f vNormNorm) {
        Vector3f axis = new Vector3f(pointA);
        axis.sub(pointB);
        float phi = axis.angle(new Vector3f(0.0f, 1.0f, 0.0f));
        if (phi == 0.0f) {
            vNormNorm.set(1.0f, 0.0f, 0.0f);
        } else {
            vNormNorm.cross(axis, new Vector3f(0.0f, 1.0f, 0.0f));
            vNormNorm.normalize();
        }
    }

    public void calcAveragePoint(Point3f pointA, Point3f pointB, Point3f pointC) {
        Vector3f v = new Vector3f(pointB);
        v.sub(pointA);
        v.scale(0.5f);
        pointC.set(pointA);
        pointC.add(v);
    }

    public void calcAveragePointN(Point3f[] points, int nPoints, Point3f averagePoint) {
        averagePoint.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < nPoints; ++i) {
            averagePoint.add(points[i]);
        }
        averagePoint.scale(1.0f / (float)nPoints);
    }

    public short getNormix(Vector3f vector) {
        return this.normix3d.getNormix(vector.x, vector.y, vector.z, 3);
    }

    public short getNormix(Vector3f vector, int geodesicLevel) {
        return this.normix3d.getNormix(vector.x, vector.y, vector.z, geodesicLevel);
    }

    public short getInverseNormix(Vector3f vector) {
        return this.normix3d.getNormix(-vector.x, -vector.y, -vector.z, 3);
    }

    public short getInverseNormix(short normix) {
        if (this.normix3d.inverseNormixes != null) {
            return this.normix3d.inverseNormixes[normix];
        }
        this.normix3d.calculateInverseNormixes();
        return this.normix3d.inverseNormixes[normix];
    }

    public short get2SidedNormix(Vector3f vector) {
        return ~this.normix3d.getNormix(vector.x, vector.y, vector.z, 3);
    }

    public boolean isDirectedTowardsCamera(short normix) {
        return this.normix3d.isDirectedTowardsCamera(normix);
    }

    public boolean isNeighborVertex(short vertex1, short vertex2, int level) {
        return Geodesic3D.isNeighborVertex(vertex1, vertex2, level);
    }

    public Vector3f[] getGeodesicVertexVectors() {
        return Geodesic3D.getVertexVectors();
    }

    public int getGeodesicVertexCount(int level) {
        return Geodesic3D.getVertexCount(level);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.normix3d.getTransformedVectors();
    }

    public Vector3f getNormixVector(short normix) {
        return this.normix3d.getVector(normix);
    }

    public int getGeodesicFaceCount(int level) {
        return Geodesic3D.getFaceCount(level);
    }

    public short[] getGeodesicFaceVertexes(int level) {
        return Geodesic3D.getFaceVertexes(level);
    }

    public short[] getGeodesicFaceNormixes(int level) {
        return this.normix3d.getFaceNormixes(level);
    }

    public short[] getGeodesicNeighborVertexes(int level) {
        return Geodesic3D.getNeighborVertexes(level);
    }

    static {
        int i;
        predefinedArgbs = new int[]{-16777216, -23296, -16181, -16776961, -1, -16711681, -65536, -16744448, -8355712, -4144960, -16711936, -8388608, -16777088, -8355840, -8388480, -16744320, -65281, -256, -38476, -10496};
        for (i = 0; i < predefinedArgbs.length; ++i) {
            if (Colix.getColix(predefinedArgbs[i]) == i + 4) continue;
            throw new NullPointerException();
        }
        shadeNormal = Shade3D.shadeNormal;
        intensitySpecularSurfaceLimit = Shade3D.intensitySpecularSurfaceLimit;
        colorNames = new String[]{"aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "black", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "pewhite"};
        colorArgbs = new int[]{-984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -16777216, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -1};
        mapJavaScriptColors = new Hashtable();
        i = colorNames.length;
        while (--i >= 0) {
            mapJavaScriptColors.put(colorNames[i], new Integer(colorArgbs[i]));
        }
    }
}

