% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{get_draws_mle}
\alias{get_draws_mle}
\title{Fit the base imputation model on bootstrap samples}
\usage{
get_draws_mle(
  longdata,
  method,
  sample_stack,
  n_target_samples,
  first_sample_orig,
  use_samp_ids,
  failure_limit = 0,
  ncores = 1,
  quiet = FALSE
)
}
\arguments{
\item{longdata}{R6 \code{longdata} object containing all relevant input data information.}

\item{method}{A \code{method} object as generated by either
\code{\link[=method_approxbayes]{method_approxbayes()}} or \code{\link[=method_condmean]{method_condmean()}} with argument \code{type = "bootstrap"}.}

\item{sample_stack}{A stack object containing the subject ids to be used on each mmrm iteration.}

\item{n_target_samples}{Number of samples needed to be created}

\item{first_sample_orig}{Logical. If \code{TRUE} the function returns \code{method$n_samples + 1} samples where
the first sample contains the parameter estimates from the original dataset and \code{method$n_samples}
samples contain the parameter estimates from bootstrap samples.
If \code{FALSE} the function returns \code{method$n_samples} samples containing the parameter estimates from
bootstrap samples.}

\item{use_samp_ids}{Logical. If \code{TRUE}, the sampled subject ids are returned. Otherwise
the subject ids from the original dataset are returned. These values are used to tell \code{\link[=impute]{impute()}}
what subjects should be used to derive the imputed dataset.}

\item{failure_limit}{Number of failed samples that are allowed before throwing an error}

\item{ncores}{Number of processes to parallelise the job over}

\item{quiet}{Logical, If \code{TRUE} will suppress printing of progress information that is printed to
the console.}
}
\value{
A \code{draws} object which is a named list containing the following:
\itemize{
\item \code{data}: R6 \code{longdata} object containing all relevant input data information.
\item \code{method}: A \code{method} object as generated by either \code{\link[=method_bayes]{method_bayes()}},
\code{\link[=method_approxbayes]{method_approxbayes()}} or \code{\link[=method_condmean]{method_condmean()}}.
\item \code{samples}: list containing the estimated parameters of interest.
Each element of \code{samples} is a named list containing the following:
\itemize{
\item \code{ids}: vector of characters containing the ids of the subjects included in the original dataset.
\item \code{beta}: numeric vector of estimated regression coefficients.
\item \code{sigma}: list of estimated covariance matrices (one for each level of \code{vars$group}).
\item \code{theta}: numeric vector of transformed covariances.
\item \code{failed}: Logical. \code{TRUE} if the model fit failed.
\item \code{ids_samp}: vector of characters containing the ids of the subjects included in the given sample.
}
\item \code{fit}: if \code{method_bayes()} is chosen, returns the MCMC Stan fit object. Otherwise \code{NULL}.
\item \code{n_failures}: absolute number of failures of the model fit.
Relevant only for \code{method_condmean(type = "bootstrap")}, \code{method_approxbayes()} and \code{method_bmlmi()}.
\item \code{formula}: fixed effects formula object used for the model specification.
}
}
\description{
Fit the base imputation model using a ML/REML approach on a given number of bootstrap samples as
specified by \code{method$n_samples}. Returns the parameter estimates from the model fit.
}
\details{
This function takes a \code{Stack} object which contains multiple lists of patient ids. The function
takes this Stack and pulls a set ids and then constructs a dataset just consisting of these
patients (i.e. potentially a bootstrap or a jackknife sample).

The function then fits a MMRM model to this dataset to create a sample object. The function
repeats this process until \code{n_target_samples} have been reached. If more than \code{failure_limit}
samples fail to converge then the function throws an error.

After reaching the desired number of samples the function generates and returns a draws object.
}
