% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand}
\alias{expand}
\alias{fill_locf}
\alias{expand_locf}
\title{Expand and fill in missing \code{data.frame} rows}
\usage{
expand(data, ...)

fill_locf(data, vars, group = NULL, order = NULL)

expand_locf(data, ..., vars, group, order)
}
\arguments{
\item{data}{dataset to expand or fill in.}

\item{...}{variables and the levels that should be expanded out (note that duplicate entries of
levels will result in multiple rows for that level).}

\item{vars}{character vector containing the names of variables that need to be filled in.}

\item{group}{character vector containing the names of variables to group
by when performing LOCF imputation of \code{var}.}

\item{order}{character vector containing the names of additional variables to sort the \code{data.frame}
by before performing LOCF.}
}
\description{
These functions are essentially wrappers around \code{\link[base:expand.grid]{base::expand.grid()}} to ensure that missing
combinations of data are inserted into a \code{data.frame} with imputation/fill methods for updating
covariate values of newly created rows.
}
\details{
The \code{\link[=draws]{draws()}} function makes the assumption that all subjects and visits are present
in the \code{data.frame} and that all covariate values are non missing; \code{expand()},
\code{fill_locf()} and \code{expand_locf()} are utility functions to support users in ensuring
that their \code{data.frame}'s conform to these assumptions.

\code{expand()} takes vectors for expected levels in a \code{data.frame} and expands out all
combinations inserting any missing rows into the \code{data.frame}. Note that all "expanded"
variables are cast as factors.

\code{fill_locf()} applies LOCF imputation to named covariates to fill in any NAs created
by the insertion of new rows by \code{expand()} (though do note that no distinction is
made between existing NAs and newly created NAs). Note that the \code{data.frame} is sorted
by \code{c(group, order)} before performing the LOCF imputation; the \code{data.frame}
will be returned in the original sort order however.

\code{expand_locf()} a simple composition function of \code{fill_locf()} and \code{expand()} i.e.
\code{fill_locf(expand(...))}.
\subsection{Missing First Values}{

The \code{fill_locf()} function performs last observation carried forward imputation.
A natural consequence of this is that it is unable to impute missing observations if the
observation is the first value for a given subject / grouping.
These values are deliberately not imputed as doing so risks silent errors in the case of time
varying covariates.
One solution is to first use \code{expand_locf()} on just
the visit variable and time varying covariates and then merge on the baseline covariates
afterwards i.e.

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(dplyr)

dat_expanded <- expand(
    data = dat,
    subject = c("pt1", "pt2", "pt3", "pt4"),
    visit = c("vis1", "vis2", "vis3")
)

dat_filled <- dat_expanded \%>\%
    left_join(baseline_covariates, by = "subject")
}\if{html}{\out{</div>}}
}
}
\examples{
\dontrun{
dat_expanded <- expand(
    data = dat,
    subject = c("pt1", "pt2", "pt3", "pt4"),
    visit = c("vis1", "vis2", "vis3")
)

dat_filled <- fill_loc(
    data = dat_expanded,
    vars = c("Sex", "Age"),
    group = "subject",
    order = "visit"
)

## Or

dat_filled <- expand_locf(
    data = dat,
    subject = c("pt1", "pt2", "pt3", "pt4"),
    visit = c("vis1", "vis2", "vis3"),
    vars = c("Sex", "Age"),
    group = "subject",
    order = "visit"
)
}
}
