% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\alias{impute.random}
\alias{impute.condmean}
\title{Create imputed datasets}
\usage{
impute(
  draws,
  references = NULL,
  update_strategy = NULL,
  strategies = getStrategies()
)

\method{impute}{random}(
  draws,
  references = NULL,
  update_strategy = NULL,
  strategies = getStrategies()
)

\method{impute}{condmean}(
  draws,
  references = NULL,
  update_strategy = NULL,
  strategies = getStrategies()
)
}
\arguments{
\item{draws}{A \code{draws} object created by \code{\link[=draws]{draws()}}.}

\item{references}{A named vector. Identifies the references to be used for reference-based
imputation methods. Should be of the form \code{c("Group1" = "Reference1", "Group2" = "Reference2")}.
If \code{NULL} (default), the references are assumed to be of the form
\code{c("Group1" = "Group1", "Group2" = "Group2")}. This argument cannot be \code{NULL} if
an imputation strategy (as defined by \code{data_ice[[vars$strategy]]} in the call to \link{draws}) other than \code{MAR} is set.}

\item{update_strategy}{An optional \code{data.frame}. Updates the imputation method that was
originally set via the \code{data_ice} option in \code{\link[=draws]{draws()}}. See the details section for more
information.}

\item{strategies}{A named list of functions. Defines the imputation functions to be used.
The names of the list should mirror the values specified in \code{strategy} column of \code{data_ice}.
Default = \code{\link[=getStrategies]{getStrategies()}}. See \code{\link[=getStrategies]{getStrategies()}} for more details.}
}
\description{
\code{impute()} creates imputed datasets based upon the data and options specified in
the call to \code{\link[=draws]{draws()}}. One imputed dataset is created per each "sample" created by
\code{\link[=draws]{draws()}}.
}
\details{
\code{impute()} uses the imputation model parameter estimates, as generated by \code{\link[=draws]{draws()}}, to
first calculate the marginal (multivariate normal) distribution of a subject's longitudinal
outcome variable
depending on their covariate values.
For subjects with intercurrent events (ICEs) handled using non-MAR methods, this marginal distribution
is then updated depending on the time of the first visit affected by the ICE,
the chosen imputation strategy and the chosen reference group as described in Carpenter, Roger, and Kenward (2013) .
The subject's imputation distribution used for imputing missing values is then defined as
their marginal distribution conditional on their observed outcome values.
One dataset is being generated per set of parameter estimates provided by \code{\link[=draws]{draws()}}.

The exact manner in how missing values are imputed from this conditional imputation distribution depends
on the \code{method} object that was provided to \code{\link[=draws]{draws()}}, in particular:
\itemize{
\item Bayes & Approximate Bayes: each imputed dataset contains 1 row per subject & visit
from the original dataset with missing values imputed by taking a single random sample
from the conditional imputation distribution.
\item Conditional Mean: each imputed dataset contains 1 row per subject & visit from the
bootstrapped or jackknife dataset that was used to generate the corresponding parameter
estimates in \code{\link[=draws]{draws()}}. Missing values are imputed by using the mean of the conditional
imputation distribution. Please note that the first imputed dataset refers to the conditional
mean imputation on the original dataset whereas all subsequent imputed datasets refer to
conditional mean imputations for bootstrap or jackknife samples, respectively, of the original data.
\item Bootstrapped Maximum Likelihood MI (BMLMI): it performs \code{D} random imputations of each bootstrapped
dataset that was used to generate the corresponding parameter estimates in \code{\link[=draws]{draws()}}. A total number of
\code{B*D} imputed datasets is provided, where \code{B} is the number of bootstrapped datasets. Missing values
are imputed by taking a random sample from the conditional imputation distribution.
}

The \code{update_strategy} argument can be used to update the imputation strategy that was
originally set via the \code{data_ice} option in \code{\link[=draws]{draws()}}. This avoids having to re-run the \code{\link[=draws]{draws()}}
function when changing the imputation strategy in certain circumstances (as detailed below).
The \code{data.frame} provided to \code{update_strategy} argument must contain two columns,
one for the subject ID and another for the imputation strategy, whose names are the same as
those defined in the \code{vars} argument as specified in the call to \code{\link[=draws]{draws()}}. Please note that this
argument only allows you to update the imputation strategy and not other arguments such as the
time of the first visit affected by the ICE.
A key limitation of this functionality is
that one can only switch between a MAR and a non-MAR strategy (or vice versa) for subjects without
observed post-ICE data. The reason for this is that such a change would affect whether the post-ICE data is included
in the base imputation model or not (as explained in the help to \code{\link[=draws]{draws()}}).
As an example, if a subject had their ICE on "Visit 2"
but had observed/known values for "Visit 3" then the function will throw an error
if one tries to switch the strategy from MAR to a non-MAR strategy. In contrast, switching from
a non-MAR to a MAR strategy, whilst valid, will raise a warning as not all usable data
will have been utilised in the imputation model.
}
\examples{
\dontrun{

impute(
    draws = drawobj,
    references = c("Trt" = "Placebo", "Placebo" = "Placebo")
)

new_strategy <- data.frame(
  subjid = c("Pt1", "Pt2"),
  strategy = c("MAR", "JR")
)

impute(
    draws = drawobj,
    references = c("Trt" = "Placebo", "Placebo" = "Placebo"),
    update_strategy = new_strategy
)
}

}
\references{
James R Carpenter, James H Roger, and Michael G Kenward. Analysis of longitudinal trials with protocol deviation:
a framework for relevant,
accessible assumptions, and inference via multiple imputation. Journal of Biopharmaceutical Statistics,
23(6):1352–1371, 2013. [Section 4.2 and 4.3]
}
