% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_dropout}
\alias{simulate_dropout}
\title{Simulate drop-out}
\usage{
simulate_dropout(prob_dropout, ids, subset = rep(1, length(ids)))
}
\arguments{
\item{prob_dropout}{Numeric that specifies the probability that a post-baseline visit is
affected by study drop-out.}

\item{ids}{Factor variable that specifies the id of each subject.}

\item{subset}{Binary variable that specifies the subset that could be affected by drop-out.
I.e. \code{subset} is a binary vector
of length equal to the length of \code{ids} that takes value \code{1} if the corresponding visit could
be affected by drop-out and \code{0} otherwise.}
}
\value{
A binary vector of length equal to the length of \code{ids} that takes value \code{1} if the
corresponding outcome is
affected by study drop-out.
}
\description{
Simulate drop-out
}
\details{
\code{subset} can be used to specify outcome values that cannot be affected by the
drop-out. By default
\code{subset} will be set to \code{1} for all the values except the values corresponding to the
baseline outcome, since baseline is supposed to not be affected by drop-out.
Even if \code{subset} is specified by the user, the values corresponding to the baseline
outcome are still hard-coded to be \code{0}.
}
