% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool_internal}
\alias{pool_internal}
\alias{pool_internal.jackknife}
\alias{pool_internal.bootstrap}
\alias{pool_internal.bmlmi}
\alias{pool_internal.rubin}
\title{Internal Pool Methods}
\usage{
pool_internal(results, conf.level, alternative, type, D)

\method{pool_internal}{jackknife}(results, conf.level, alternative, type, D)

\method{pool_internal}{bootstrap}(
  results,
  conf.level,
  alternative,
  type = c("percentile", "normal"),
  D
)

\method{pool_internal}{bmlmi}(results, conf.level, alternative, type, D)

\method{pool_internal}{rubin}(results, conf.level, alternative, type, D)
}
\arguments{
\item{results}{a list of results i.e. the \code{x$results} element of an
\code{analyse} object created by \code{\link[=analyse]{analyse()}}).}

\item{conf.level}{confidence level of the returned confidence interval.
Must be a single number between 0 and 1. Default is 0.95.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{type}{a character string of either \code{"percentile"} (default) or
\code{"normal"}. Determines what method should be used to calculate the bootstrap confidence
intervals. See details.
Only used if \code{method_condmean(type = "bootstrap")} was specified
in the original call to \code{\link[=draws]{draws()}}.}

\item{D}{numeric representing the number of imputations between each bootstrap sample in the BMLMI method.}
}
\description{
Dispatches pool methods based upon results object class. See
\code{\link[=pool]{pool()}} for details.
}
