% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{get_example_data}
\alias{get_example_data}
\title{Simulate a realistic example dataset}
\usage{
get_example_data()
}
\description{
Simulate a realistic example dataset using \code{\link[=simulate_data]{simulate_data()}} with hard-coded
values of all the input arguments.
}
\details{
\code{\link[=get_example_data]{get_example_data()}} simulates a 1:1 randomized trial of
an active drug (intervention) versus placebo (control) with 100 subjects per
group and 6 post-baseline assessments (bi-monthly visits until 12 months).
One intercurrent event corresponding to treatment discontinuation is also simulated.
Specifically, data are simulated under the following assumptions:
\itemize{
\item The mean outcome trajectory in the placebo group increases linearly from
50 at baseline (visit 0) to 60 at visit 6, i.e. the slope is 10 points/year.
\item The mean outcome trajectory in the intervention group is identical to the
placebo group up to visit 2. From visit 2 onward, the slope decreases by 50\% to 5 points/year.
\item The covariance structure of the baseline and follow-up values in both groups
is implied by a random intercept and slope model with a standard deviation of 5
for both the intercept and the slope, and a correlation of 0.25.
In addition, an independent residual error with standard deviation 2.5 is added
to each assessment.
\item The probability of study drug discontinuation after each visit is calculated
according to a logistic model which depends on the observed outcome at that visit.
Specifically, a visit-wise discontinuation probability of 2\% and 3\% in the control
and intervention group, respectively, is specified in case the observed outcome is
equal to 50 (the mean value at baseline). The odds of a discontinuation is simulated
to increase by +10\% for each +1 point increase of the observed outcome.
\item Study drug discontinuation is simulated to have no effect on the mean trajectory in
the placebo group. In the intervention group, subjects who discontinue follow
the slope of the mean trajectory from the placebo group from that time point onward.
This is compatible with a copy increments in reference (CIR) assumption.
\item Study drop-out at the study drug discontinuation visit occurs with a probability
of 50\% leading to missing outcome data from that time point onward.
}
}
\seealso{
\code{\link[=simulate_data]{simulate_data()}}, \code{\link[=set_simul_pars]{set_simul_pars()}}
}
