% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{run}
\alias{run}
\alias{run.libbi}
\title{Using the LibBi wrapper to launch LibBi}
\usage{
\method{run}{libbi}(x, client, proposal = c("model", "prior"), model, fix,
  options, config, add_options, log_file_name, stdoutput_file_name, init, input,
  obs, time_dim, coord_dims, working_folder, output_all, sample_obs, thin,
  chain = TRUE, seed = TRUE, ...)
}
\arguments{
\item{x}{a \code{\link{libbi}} object}

\item{client}{client to pass to LibBi}

\item{proposal}{proposal distribution to use; either "model" (default: proposal distribution in the model) or "prior" (propose from the prior distribution)}

\item{model}{either a character vector giving the path to a model file (typically ending in ".bi"), or a \code{bi_model} object; by default, will use any model given in \code{x}}

\item{fix}{any variable to fix, as a named vector}

\item{options}{list of additional arguments to pass to the call to \code{LibBi}. Any arguments starting with `enable`/`disable` can be specified as boolean (e.g., `assert=TRUE`). Any `dry-` options can be specified with a `"dry"` argument, e.g., `parse="dry"`. Any options that would be specified with `with`/`without` can be specified as character vector to an option named `with`/`without`, respectively, e.g. with="transform-obs-to-state".}

\item{config}{path to a configuration file, containing multiple arguments}

\item{add_options}{deprecated, replaced by \code{options}}

\item{log_file_name}{path to a file to text file to report the output of \code{LibBi}}

\item{stdoutput_file_name}{deprecated; use log_file_name instead}

\item{init}{initialisation of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as input). If the object given as \code{x} has been run before, it will be used here with \code{init-np} set to the last iteration of the previous run, unless \code{init} is given explicitly.}

\item{input}{input of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as input)}

\item{obs}{observations of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as observations)}

\item{time_dim}{The time dimension in any R objects that have been passed (\code{init}, \code{input}) and \code{obs}); if not given, will be guessed}

\item{coord_dims}{The coord dimension(s) in any \code{obs} R objects that have been passed; if not given, will be guessed}

\item{working_folder}{path to a folder from which to run \code{LibBi}; default to a temporary folder.}

\item{output_all}{logical; if set to TRUE, all parameters, states and observations will be saved; good for debugging}

\item{sample_obs}{logical; if set to TRUE, will sample observations}

\item{thin}{any thinning of MCMC chains (1 means all will be kept, 2 skips every other sample etc.); note that \code{LibBi} itself will write all data to the disk. Only when the results are read in with \code{\link{bi_read}} will thinning be applied.}

\item{chain}{logical; if set to TRUE and \code{x} has been run before, the previous output file will be used as \code{init} file, and \code{init-np} will be set to the last iteration of the previous run (unless target=="prediction"). This is useful for running inference chains.}

\item{seed}{Either a number (the seed to supply to \code{LibBi}), or a logical variable: TRUE if a seed is to be generated for \code{RBi}, FALSE if \code{LibBi} is to generate its own seed}

\item{...}{any unrecognised options will be added to \code{options}}
}
\value{
a \code{\link{libbi}} object, except if \code{client} is 'rewrite',  in which case a \code{\link{bi_model}} object will be returned
}
\description{
The method \code{run} launches \code{LibBi} with a particular set of command line #' arguments. Normally, this function would not be run by the user, but instead one of the client functions \code{\link{sample}}, \code{\link{filter}}, or \code{\link{optimise}}, or \code{\link{rewrite}}, which pass any options on to \code{run}. Note that any options specified here are stored in the \code{\link{libbi}} object and do not have to be specified again if another command is run on the object.
}
\examples{
bi_object <- libbi(model = system.file(package="rbi", "PZ.bi"))
\dontrun{run(bi_object, options=list(client="sample", sample="smc2"))}
if (bi_object$run_flag) {
  bi_file_summary(bi_object$output_file_name)
}
}
\seealso{
\code{\link{libbi}}
}
