% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-yc.R
\name{yc_get}
\alias{yc_get}
\alias{yc_mget}
\title{Fetches Yield Curve Data from B3}
\usage{
yc_mget(
  first_date = Sys.Date() - 5,
  last_date = Sys.Date(),
  by = 1,
  cache_folder = cachedir(),
  do_cache = TRUE
)

yc_get(refdate = Sys.Date(), cache_folder = cachedir(), do_cache = TRUE)
}
\arguments{
\item{first_date}{First date ("YYYY-MM-DD") to \code{yc_mget} multiple curves}

\item{last_date}{Last date ("YYYY-MM-DD") to \code{yc_mget} multiple curves}

\item{by}{Number of days in between fetched dates (default = 1) in \code{yc_mget}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)

\code{yc_get} returns the yield curve for the given date and \code{yc_mget} returns
multiple yield curves for a given range of dates.}

\item{refdate}{Specific date ("YYYY-MM-DD") to \code{yc_get} single curve}
}
\value{
A dataframe/tibble with yield curve data
}
\description{
Downloads yield curve data from B3 website
\url{https://www2.bmf.com.br/pages/portal/bmfbovespa/lumis/lum-taxas-referenciais-bmf-ptBR.asp}.
Particularly, we import data for DI X Pre.
See \url{https://www.b3.com.br/data/files/8B/F5/11/68/5391F61043E561F6AC094EA8/Manual_de_Curvas.pdf}
for more details.
}
\examples{
\dontrun{
df_yc <- yc_mget(first_date = Sys.Date() - 5, last_date = Sys.Date())
head(df_yc)
}
\dontrun{
df_yc <- yc_get(Sys.Date())
head(df_yc)
}
}
