% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_normal.R
\name{calculate_normal}
\alias{calculate_normal}
\title{Calculate Normal}
\usage{
calculate_normal(heightmap, zscale = 1, progbar = FALSE)
}
\arguments{
\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point. All points are assumed to be evenly spaced.}

\item{zscale}{Default 1.}

\item{progbar}{Default `FALSE`. If `TRUE`, turns on progress bar.}
}
\value{
Matrix of light intensities at each point.
}
\description{
Calculates the normal unit vector for every point on the grid.
}
\examples{
#Here we produce a light intensity map of the `volcano` elevation map.

#Cache the normal vectors of the volcano dataset
if(rayshader:::run_documentation()) {
volcanocache = calculate_normal(volcano)
}

#Use the cached vectors to speed up calculation of `sphere_shade()` on a map.
if(rayshader:::run_documentation()) {
sphere_shade(volcano,normalvectors = volcanocache) \%>\%
 plot_map()
}
}
