% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{ply_model}
\alias{ply_model}
\title{`ply` File Object}
\usage{
ply_model(
  filename,
  x = 0,
  y = 0,
  z = 0,
  scale_ply = 1,
  subdivision_levels = 1,
  recalculate_normals = FALSE,
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  flipped = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{filename}{Filename and path to the `ply` file. Can also be a `txt` file, if it's in the correct `ply` internally.}

\item{x}{Default `0`. x-coordinate to offset the model.}

\item{y}{Default `0`. y-coordinate to offset the model.}

\item{z}{Default `0`. z-coordinate to offset the model.}

\item{scale_ply}{Default `1`. Amount to scale the model. Use this to scale the object up or down on all axes, as it is
more robust to numerical precision errors than the generic scale option.}

\item{subdivision_levels}{Default `1`. Number of Loop subdivisions to be applied to the mesh.}

\item{recalculate_normals}{Default `FALSE`. Whether to recalculate vertex normals based on the 
connecting face orientations. This can be used to compute normals for meshes lacking them or
to calculate new normals after a displacement map has been applied to the mesh.}

\item{material}{Default  \code{\link{diffuse}}.The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the obj model in the scene.
}
\description{
Load an PLY file via a filepath. 
Note: light importance sampling currently not supported for this shape.
}
\examples{
#See the documentation for `obj_model()`--no example PLY models are included with this package,
#but the process of loading a model is the same (without support for vertex colors).
}
