% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_update_normals}
\alias{vcg_update_normals}
\title{Update vertex normal}
\usage{
vcg_update_normals(
  mesh,
  weight = c("area", "angle"),
  pointcloud = c(10, 0),
  verbose = FALSE
)
}
\arguments{
\item{mesh}{triangular mesh or a point-cloud (matrix of 3 columns)}

\item{weight}{method to compute per-vertex normal vectors: \code{"area"}
weighted average of surrounding face normal, or \code{"angle"} weighted
vertex normal vectors.}

\item{pointcloud}{integer vector of length 2: containing optional
parameters for normal calculation of point clouds; the first entry
specifies the number of neighboring points to consider; the second
entry specifies the amount of smoothing iterations to be performed.}

\item{verbose}{whether to verbose the progress}
}
\value{
A \code{'mesh3d'} object with normal vectors.
}
\description{
Update vertex normal
}
\examples{

if(is_not_cran()) {

# Prepare mesh with no normal
data("left_hippocampus_mask")
mesh <- vcg_isosurface(left_hippocampus_mask)
mesh$normals <- NULL

# Start: examples
new_mesh <- vcg_update_normals(mesh, weight = "angle",
                               pointcloud = c(10, 10))

rgl_view({
  rgl_call("mfrow3d", 1, 2)
  rgl_call("shade3d", mesh, col = 2)

  rgl_call("next3d")
  rgl_call("shade3d", new_mesh, col = 2)
})
}


}
