% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.R
\name{collapse}
\alias{collapse}
\alias{collapse.array}
\title{Collapse array}
\usage{
collapse(x, keep, ...)

\method{collapse}{array}(
  x,
  keep,
  average = TRUE,
  transform = c("asis", "10log10", "square", "sqrt"),
  ...
)
}
\arguments{
\item{x}{A numeric multi-mode tensor (array), without \code{NA}}

\item{keep}{Which dimension to keep}

\item{...}{passed to other methods}

\item{average}{collapse to sum or mean}

\item{transform}{transform on the data before applying collapsing;
choices are \code{'asis'} (no change), \code{'10log10'} (used to calculate
decibel), \code{'square'} (sum-squared), \code{'sqrt'} (square-root and
collapse)}
}
\value{
a collapsed array with values to be mean or summation along
collapsing dimensions
}
\description{
Collapse array
}
\examples{

# Set ncores = 2 to comply to CRAN policy. Please don't run this line
ravetools_threads(n_threads = 2L)

# Example 1
x = matrix(1:16, 4)

# Keep the first dimension and calculate sums along the rest
collapse(x, keep = 1)
rowMeans(x)  # Should yield the same result

# Example 2
x = array(1:120, dim = c(2,3,4,5))
result = collapse(x, keep = c(3,2))
compare = apply(x, c(3,2), mean)
sum(abs(result - compare)) # The same, yield 0 or very small number (1e-10)


if(interactive()){
ravetools_threads(n_threads = -1)

# Example 3 (performance)

# Small data, no big difference
x = array(rnorm(240), dim = c(4,5,6,2))
microbenchmark::microbenchmark(
  result = collapse(x, keep = c(3,2)),
  compare = apply(x, c(3,2), mean),
  times = 1L, check = function(v){
    max(abs(range(do.call('-', v)))) < 1e-10
  }
)

# large data big difference
x = array(rnorm(prod(300,200,105)), c(300,200,105,1))
microbenchmark::microbenchmark(
  result = collapse(x, keep = c(3,2)),
  compare = apply(x, c(3,2), mean),
  times = 1L , check = function(v){
    max(abs(range(do.call('-', v)))) < 1e-10
  })

}

}
