% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ratios.R
\name{preparation.DT2}
\alias{preparation.DT2}
\title{preparation.DT2}
\usage{
preparation.DT2(DT1, DT2, vars = NULL, group1.vars, group2.vars = NULL,
  Errors = FALSE, use_only_DT2 = FALSE, DT2_replace = NULL, minNr = 7,
  STD = NULL, return_as_list = FALSE)
}
\arguments{
\item{DT1}{data.frame or data.table, samples in rows and elements and other information in columns}

\item{DT2}{data.frame or data.table of DT2 or crust data, samples in rows and elements and other information in columns.}

\item{vars}{optional, character vector of column names of DT1 and DT2, default is function \code{\link{select.VarsElements}}.
Please make sure the columns given in \code{vars} are of class numeric.}

\item{group1.vars}{character vector, column name(s) for subsetting DT1 and DT2}

\item{group2.vars}{optional, column name for subsetting DT1 and DT2 if some entries in \code{group1.vars} are empty.}

\item{Errors}{logical, should absolute errors get calculated appended to the list - output? Default is FALSE.
If Errors are set to TRUE it overrides the option \code{return_as_list} and always returns a list.}

\item{use_only_DT2}{logical, default is FALSE. If there are not enough DT2 data of the location should the DT2s of the region be used? If the \code{use_only_DT2} is set to FALSE then the Upper Crust is used for the correction.}

\item{DT2_replace}{optional, if a DT1 sample does not have DT2 data of the corresponding location with this option you can define which data you would like to use as DT2.
Default is the UpperCrust. If you would like to have something else, please provide a named vector/ one-row data.table with values used instead of DT2}

\item{minNr}{minimum numbers of samples/observations for calculating a relative error of observations.
If the number of samples of "Data" is smaller than "minNr" the error is calculated via the data set STD.}

\item{STD}{replacement data set for calculating errors, e.g. the standards.}

\item{return_as_list}{logical, should the result get returned as list? Default is FALSE.}
}
\value{
data.frame, data.table or a list, controlled by option \code{return_as_list}.
If \code{Errors} is set to TRUE \code{return_as_list} is ignored and return value is always a list.
The list contains one element if \code{Errors} is set to FALSE and two elements if \code{Errors} is TRUE:
[[1]] is data.table or data.frame of corresponding DT2s, [[2]] data.table or data.frame of absolute errors of corresponding DT2s.
}
\description{
The function creates a data set 'new DT2' from the variables \code{vars} of DT2, which has equal number of rows to DT1.
The column \code{group1.vars} (and optional \code{group2.vars}) in DT1 is the look-up table for creating the 'new DT2'.
Generally DT1 and DT2 have to have the columns in common which are given in \code{group1.vars}, optional \code{group2.vars} and \code{vars}.

The data set 'new DT2' is generated according to following rules:
If there is more than one row in DT2 with the same entry for \code{group1.vars} for each column in \code{vars} an average (mean) of these rows of DT2 is calculated.
After this operation there is only one row for each entry value of \code{group1.vars}.
Each row of this averaged DT2 is replicated n times, with n being the number of rows of the subset of DT1 with the corresponding value in \code{group1.vars}.
If there are values in column \code{group1.vars} in DT1 which are not in DT2 and if option \code{use_only_DT2} is set to \code{TRUE} empty rows are generated.
If option \code{use_only_DT2} is set to \code{FALSE}, data from 'DT2_replace' are taken as substitute for DT2 to fill these empty rows.
The default 'DT2_replace' are element concentrations from the UpperCrust (Rudnick, R. L., & Gao, S. 2003. Composition of the continental crust. \emph{Treatise on geochemistry, 3}, 659.)
}
\seealso{
Other ratio functions: \code{\link{Correction.AdheringParticles}},
  \code{\link{ratio.DT1_DT2}},
  \code{\link{ratio.append_smallest}}
}
\author{
Solveig Pospiech
}
