% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rater_fit_class.R
\name{plot.rater_fit}
\alias{plot.rater_fit}
\title{Plot a \code{rater_fit} object}
\usage{
\method{plot}{rater_fit}(x, pars = c("pi", "theta", "class_probabilities"), ...)
}
\arguments{
\item{x}{An object of class \code{rater_fit}.}

\item{pars}{A character vector of the names of the parameters to plot. By
default: \code{c("pi", "theta", "class_probabilities")}.}

\item{...}{Other arguments. This should contain the which argument for
theta plots.}
}
\value{
If one parameter is requested a ggplot2 plot. If multiple parameters
are requested a list of ggplot2 plots.
}
\description{
Plot a \code{rater_fit} object
}
\examples{

\donttest{
fit <- rater(anesthesia, "dawid_skene")

# Plot all the parameters.
plot(fit)

# Select which parameters to plot.
plot(fit, pars = "pi")

}

}
