% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqDT.R
\name{freqDT}
\alias{freqDT}
\alias{freqDT,RasterLayer-method}
\alias{freqDT,RasterStackBrick-method}
\title{Speedy Raster Value Frequency Tabulation}
\usage{
freqDT(x, ...)

\S4method{freqDT}{RasterLayer}(x, digits = 0, value = NULL, useNA = c("ifany", "no", "always"), ...)

\S4method{freqDT}{RasterStackBrick}(
  x,
  digits = 0,
  value = NULL,
  useNA = c("ifany", "no", "always"),
  merge = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{RasterLayer}, \code{RasterStack}, or
\code{RasterBrick} object field class.}

\item{...}{Additional arguments as for
\code{\link[raster:writeRaster]{raster::writeRaster()}}, on
which this function relies.}

\item{digits}{Integer for rounding the cell values. Argument is
passed to \code{\link[base]{round}}}

\item{value}{A single numeric, logical, or NA value. If supplied,
\code{freqDT()} will only count the number of cells with that
value.}

\item{useNA}{Character (one of "no", "ifany", or "always"). What
to do with NA values? See \code{\link[base]{table}} for details.}

\item{merge}{Logical. If \code{TRUE} the list will be merged into
a single \code{data.table}.}
}
\description{
A fast \code{data.table}-based alternative to
\code{\link[raster:freq]{raster::freq()}}.
}
\examples{
r <- raster(nrow = 18, ncol = 36)
r[] <- runif(ncell(r))
r[1:5] <- NA
r <- r * r * r * 5
freqDT(r)

freqDT(r, value = 2)

s <- stack(r, r*2, r*3)
freqDT(s, merge = TRUE)
}
\author{
Joshua O'Brien
}
