% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spie.R
\name{PlotSpie}
\alias{PlotSpie}
\title{Illustrate beading plot}
\usage{
PlotSpie(data, color = NULL)
}
\arguments{
\item{data}{DATA of metrics for treatment ranking.}

\item{color}{LIST of colors for outcomes in a network meta-analysis.}
}
\value{
\strong{PlotSpie()} returns a spie plot.
}
\description{
\strong{PlotSpie()} is a function for illustrating spie plot.
}
\examples{
## Not run:
#library(netmeta)
#data(Senn2013)
#nma <- netmeta(TE, seTE, treat1, treat2,
#studlab, data = Senn2013, sm = "SMD")

# Get SUCRA
#nma.1 <- GetMetrics(nma, outcome = "HbA1c.random", prefer = "small", metrics = "SUCRA",
#model = "random", simt = 1000)
#nma.2 <- GetMetrics(nma, outcome = "HbA1c.common", prefer = "small", metrics = "SUCRA",
#model = "common", simt = 1000)

# Combine metrics of multiple outcomes
#dataMetrics <- rbind(nma.1, nma.2)

# Set data for rankinma
#dataRankinma <- SetMetrics(dataMetrics, tx = tx, outcome = outcome,
#metrics = SUCRA, metrics.name = "SUCRA")

# Illustrate beading plot
#PlotSpie(data = dataRankinma)
## End(Not run)

}
\references{
Daly, C. H., Mbuagbaw, L., Thabane, L., Straus, S. E., & Hamid, J. S. (2020).
Spie charts for quantifying treatment effectiveness and safety in multiple
outcome network meta-analysis: a proof-of-concept study.
\strong{BMC Medical Research Methodology}, \emph{20}, 1-13.
}
\seealso{
\code{\link{GetMetrics}}, \code{\link{SetMetrics}},
\code{\link{PlotBeads}}, \code{\link{PlotBar}},
\code{\link{PlotLine}}, \code{\link{PlotHeat}}
}
\author{
Enoch Kang
}
