% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Partition the order generated by a set of intervals}
\usage{
partition(intervals)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}
}
\value{
A list whose entries correspond to sets in the partition
}
\description{
A partition of the order generated by a set of intervals is a partition of
their indices with the property the sets can be ordered so that the right
endpoint of every interval in a set is less than the left endpoint of any
interval in any subsequent set.
}
\details{
See section 3.2 of Rising (2021).
}
\examples{
left <- sort(c(1:3, 1:3 + 0.1))
right <- left + 0.7
intervals <- data.frame(left = left, right = right)
partition(intervals)
}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
