% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{rmmCheckEmpty}
\alias{rmmCheckEmpty}
\title{Check an rmm object for empty fields}
\usage{
rmmCheckEmpty(rmm, family = c("base", "obligate"))
}
\arguments{
\item{rmm}{a range model metadata list}

\item{family}{an rmm family, "apObligate" by default}
}
\value{
A dataframe containing empty fields labelled as obligate, optional, or suggested.
}
\description{
Identify empty fields in an rmm object and classify these into obligate and optional fields.
}
\details{
See Examples.
}
\examples{
#First, make an empty rmm object:
rmm<-rmmTemplate()
#Next, we check for emtpy fields:
empties1<-rmmCheckEmpty(rmm = rmm)
#If looks like there are quite a few empty obligate fields.  Let's populate a few:
rmm$data$occurrence$taxon<-"Acer rubrum"
rmm$data$environment$variableNames<-"Bio1"
#Now, if we run rmmCheckEmpty again, we see there are 2 fewer empty, obligate fields
empties2<-rmmCheckEmpty(rmm = rmm)


}
\seealso{
Other check: \code{\link{rmmCheckFinalize}},
  \code{\link{rmmCheckMissingNames}},
  \code{\link{rmmCheckName}}, \code{\link{rmmCheckValue}},
  \code{\link{rmmCleanNULLs}}
}
\author{
Cory Merow <cory.merow@gmail.com>, Brian Maitner <bmaitner@gmail.com>,
}
