% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadataUpdate-methods.R
\name{metadata.update}
\alias{metadata.update}
\title{Updates metadata table}
\usage{
metadata.update(rangeMap, FUN, name, map, overwrite = FALSE, ...)
}
\arguments{
\item{rangeMap}{A \code{\link{rangeMap}} object.}

\item{FUN}{Function used to aggregate the map values corresponding to each
range}

\item{name}{The name of the new \code{metadata_table} field containing the
variable computed by \code{FUN}}

\item{map}{Single-band \code{\link[sp]{SpatialGridDataFrame}} object}

\item{overwrite}{If set to \code{TRUE} the the values of the field are
replaced}

\item{\dots}{extra arguments (e.g. \code{na.rm = TRUE}) to be passed to FUN.}
}
\value{
NULL.
}
\description{
Updates \code{metadata_table} of a \code{rangeMapper} project \emph{after}
importing ranges with \code{\link{processRanges}}.
}
\note{
In order to compute taxa-level metadata which are not dependent on the
                 project's resolution use \code{\link{processRanges}} with a \code{metadata}
                 argument. See \code{\link{rangeTraits}} for more details. \cr The method can
                 be extended to work with raster or vector objects (e.g. lines, polygons,
                 points) using overlaying functions in the package \code{raster} and
                 \code{rgeos} respectively.
}
\examples{

require(rangeMapper)
require(rgdal)
# data
spdf = readOGR(system.file(package = "rangeMapper",
	"extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)
rloc = system.file(package = "rangeMapper", "extdata",
	"etopo1", "etopo1_Americas.tif")
r = readGDAL(rloc, output.dim = c(50, 50))
spdf = spTransform(spdf, CRS(proj4string(r)) )

# the project
dbcon = rangeMap.start(file = "wrens.sqlite", overwrite = TRUE,
	dir = tempdir() )
rmap = new("rangeMap", CON = dbcon)
global.bbox.save(con = dbcon, bbox = spdf )
gridSize.save(dbcon, gridSize = 300000)
canvas.save(dbcon)
processRanges(spdf = spdf, con =  dbcon, ID = "sci_name" )

# metadata.update
metadata.update (rmap,
 FUN = function(x, ...) {
 	res = diff(range(x, ...))
 	if( !is.finite(res)) res = 0
 	res
 	},
	name = 'AltitudeRange', map = r, na.rm = TRUE, overwrite = TRUE)
# plot
mr = RSQLite::dbGetQuery(dbcon, 'select * from metadata_ranges')
maxRangeSp = mr[mr$AltitudeRange== max(mr$AltitudeRange), 'bioid']
image(r)
plot(rangeFetch(rmap, maxRangeSp), add = TRUE, border = 4, lwd = 3)
title(main = maxRangeSp)

}

