% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half_life_2pt.R
\name{half_life_2pt}
\alias{half_life_2pt}
\title{Calculate half-life based on two data points}
\usage{
half_life_2pt(time1, time2, N1, N2)
}
\arguments{
\item{time1}{First time: Must be numeric with no formatting.}

\item{time2}{Second time: Must be numeric with no formatting.}

\item{N1}{First measurement - can be count rate, dose rate, etc.}

\item{N2}{Second measurement in units consistent with first measurement.}
}
\value{
The calculated half-life in units of time input.
}
\description{
Estimate half-life from two data points. Half-life units are
  consistent with time units of input.
  @family rad measurements
}
\examples{
half_life_2pt(2015, 2016, 45, 30)
half_life_2pt(0, 60, 60, 15)
}
