% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{refactor}
\alias{refactor}
\title{Remove/reorder levels}
\usage{
refactor(x, levs = levels(x), repl = NA)
}
\arguments{
\item{x}{Character or Factor}

\item{levs}{Set of levels to use}

\item{repl}{String (or NA) used to replace missing levels}
}
\description{
Remove/reorder levels
}
\details{
Keep only a specific set of levels in a factor. By removing levels the base for comparison in, e.g., regression analysis, becomes the first level. To relabel the base use, for example, repl = 'other'
}
\examples{
refactor(diamonds$cut, c("Premium", "Ideal")) \%>\% head()
refactor(diamonds$cut, c("Premium", "Ideal"), "Other") \%>\% head()

}
