% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_to_cartesian.R
\name{polar_to_cartesian}
\alias{polar_to_cartesian}
\title{Polar to Cartesian Coordinates}
\usage{
polar_to_cartesian(polar, threads = 1, digits = NULL)
}
\arguments{
\item{polar}{A \code{data.table} with three columns describing the zenith, azimuth, and distance of a point to the center.}

\item{threads}{An \code{integer} vector describing the number of threads for parallel processing. Default 1.}

\item{digits}{A \code{numeric} vector of length 1 describing the decimal numbers to \code{\link{round}} the cartesian coordinates. If \code{NULL}, \code{\link{round}} does not apply. \code{NULL} as default.}
}
\value{
A \code{data.table} with three columns describing the *XYZ* of the cartesian coordinates.
}
\description{
Convert from polar to cartesian coordinates.
}
\examples{

#Creates a hemisphere of points each 2 degrees

zenith <- seq(0, 90, 2)
azimuth <- seq(0, 360, 2)
hemi <- CJ(zenith, azimuth)
hemi$distance <- 1
hemicloud <- polar_to_cartesian(hemi)
rgl::plot3d(hemicloud)

}
\seealso{
\code{\link{cartesian_to_polar}}
}
\author{
J. Antonio Guzmán Q.
}
