/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.ArrayList;
import java.util.List;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyXRange;
import org.python.modules.PyTeeIterator;

public class itertools
implements ClassDictInit {
    public static PyString __doc__ = new PyString("Functional tools for creating and using iterators.\n\nInfinite iterators:\ncount([n]) --> n, n+1, n+2, ...\ncycle(p) --> p0, p1, ... plast, p0, p1, ...\nrepeat(elem [,n]) --> elem, elem, elem, ... endlessly or up to n times\n\nIterators terminating on the shortest input sequence:\nizip(p, q, ...) --> (p[0], q[0]), (p[1], q[1]), ... \nifilter(pred, seq) --> elements of seq where pred(elem) is True\nifilterfalse(pred, seq) --> elements of seq where pred(elem) is False\nislice(seq, [start,] stop [, step]) --> elements from\n       seq[start:stop:step]\nimap(fun, p, q, ...) --> fun(p0, q0), fun(p1, q1), ...\nstarmap(fun, seq) --> fun(*seq[0]), fun(*seq[1]), ...\nchain(p, q, ...) --> p0, p1, ... plast, q0, q1, ... \ntakewhile(pred, seq) --> seq[0], seq[1], until pred fails\ndropwhile(pred, seq) --> seq[n],seq[n+1], starting when pred fails\ngroupby(iterable[, keyfunc]) -> create an iterator which returns\n(key, sub-iterator) grouped by each value of key(value).tee(iterable, n=2) --> tuple of n independent iterators.");
    public static PyString __doc__count = new PyString("count([firstval]) --> count object\n\nReturn a count object whose .next() method returns consecutive\nintegers starting from zero or, if specified, from firstval.");
    public static PyString __doc__cycle = new PyString("cycle(iterable) --> cycle object\n\nReturn elements from the iterable until itis exhausted.\nThen repeat the sequence indefinitely.");
    public static PyString __doc__chain = new PyString("chain(*iterables) --> chain object\n\nReturn a chain object whose .next() method returns elements from the\nfirst iterable until it is exhausted, then elements from the next\niterable, until all of the iterables are exhausted.");
    public static PyString __doc__repeat = new PyString("'repeat(element [,times]) -> create an iterator which returns the element\nfor the specified number of times.  If not specified, returns the element\nendlessly.");
    public static PyString __doc__imap = new PyString("'map(func, *iterables) --> imap object\n\nMake an iterator that computes the function using arguments from\neach of the iterables.\tLike map() except that it returns\nan iterator instead of a list and that it stops when the shortest\niterable is exhausted instead of filling in None for shorter\niterables.");
    public static PyString __doc__islice = new PyString("islice(iterable, [start,] stop [, step]) --> islice object\n\nReturn an iterator whose next() method returns selected values from an\niterable.  If start is specified, will skip all preceding elements;\notherwise, start defaults to zero.Step defaults to one.  If\nspecified as another value, step determines how manyvalues are \nskipped between successive calls.  Works like a slice() on a list\nbut returns an iterator.");
    public static PyString __doc__ifilter = new PyString("ifilter(function or None, sequence) --> ifilter object\n\nReturn those items of sequence for which function(item) is true.\nIf function is None, return the items that are true.");
    public static PyString __doc__ifilterfalse = new PyString("'ifilterfalse(function or None, sequence) --> ifilterfalse object\n\nReturn those items of sequence for which function(item) is false.\nIf function is None, return the items that are false.'");
    public static PyString __doc__izip = new PyString("izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.");
    public static PyString __doc__starmap = new PyString("starmap(function, sequence) --> starmap object\n\nReturn an iterator whose values are returned from the function evaluated\nwith an argument tuple taken from the given sequence.");
    public static PyString __doc__dropwhile = new PyString("dropwhile(predicate, iterable) --> dropwhile object\n\nDrop items from the iterable while predicate(item) is true.\nAfterwards, return every element until theiterable is exhausted.");
    public static PyString __doc__takewhile = new PyString("takewhile(predicate, iterable) --> takewhile object\n\nReturn successive entries from an iterable as long as the \npredicate evaluates to true for each entry.");
    public static PyString __doc__groupby = new PyString("groupby(iterable[, keyfunc]) -> create an iterator which returns\n(key, sub-iterator) grouped by each value of key(value).");
    public static PyString __doc__tee = new PyString("tee(iterable, n=2) --> tuple of n independent iterators.");

    public static void classDictInit(PyObject dict) {
    }

    public static PyIterator count(final int init) {
        return new PyIterator(){
            int counter;
            {
                this.counter = init;
            }

            public PyObject __iternext__() {
                return new PyInteger(this.counter++);
            }

            public PyString __repr__() {
                return (PyString)Py.newString("count(%d)").__mod__(Py.newInteger(this.counter));
            }
        };
    }

    public static PyIterator count() {
        return itertools.count(0);
    }

    public static PyIterator cycle(final PyObject sequence) {
        return new ItertoolsIterator(){
            List saved = new ArrayList();
            int counter = 0;
            PyObject iter = sequence.__iter__();
            boolean save = true;

            public PyObject __iternext__() {
                if (this.save) {
                    PyObject obj = this.nextElement(this.iter);
                    if (obj != null) {
                        this.saved.add(obj);
                        return obj;
                    }
                    this.save = false;
                }
                if (this.saved.size() == 0) {
                    return null;
                }
                if (this.counter >= this.saved.size()) {
                    this.counter = 0;
                }
                return (PyObject)this.saved.get(this.counter++);
            }
        };
    }

    public static PyIterator chain(PyObject[] iterables) {
        final PyObject[] iterators = new PyObject[iterables.length];
        for (int i = 0; i < iterables.length; ++i) {
            iterators[i] = iterables[i].__iter__();
        }
        return new ItertoolsIterator(){
            int iteratorIndex = 0;

            public PyObject __iternext__() {
                PyObject next = null;
                while (this.iteratorIndex < iterators.length && (next = this.nextElement(iterators[this.iteratorIndex])) == null) {
                    ++this.iteratorIndex;
                }
                return next;
            }
        };
    }

    public static PyIterator repeat(final PyObject object, final int times) {
        return new PyIterator(){
            int counter;
            {
                this.counter = times;
            }

            public PyObject __iternext__() {
                if (this.counter > 0) {
                    --this.counter;
                    return object;
                }
                return null;
            }

            public int __len__() {
                return times;
            }

            public PyString __repr__() {
                return (PyString)Py.newString("repeat(%r, %d)").__mod__(new PyTuple(object, Py.newInteger(this.counter)));
            }
        };
    }

    public static PyIterator repeat(final PyObject object) {
        return new PyIterator(){

            public PyObject __iternext__() {
                return object;
            }

            public PyString __repr__() {
                return (PyString)Py.newString("repeat(%r)").__mod__(new PyTuple(object));
            }
        };
    }

    public static PyIterator imap(PyObject[] argstar) {
        final int n = argstar.length - 1;
        if (n < 1) {
            throw Py.TypeError("imap requires at least two arguments");
        }
        final PyObject callable = argstar[0];
        final PyObject[] iters = new PyObject[n];
        for (int j = 0; j < n; ++j) {
            iters[j] = Py.iter(argstar[j + 1], "argument " + (j + 1) + " to imap() must support iteration");
        }
        return new PyIterator(){
            PyObject[] args;
            PyObject element;
            {
                this.args = new PyObject[n];
                this.element = null;
            }

            public PyObject __iternext__() {
                for (int i = 0; i < n; ++i) {
                    this.element = iters[i].__iternext__();
                    if (this.element == null) {
                        return null;
                    }
                    this.args[i] = this.element;
                }
                if (callable == Py.None) {
                    if (n == 1) {
                        return this.args[0];
                    }
                    return new PyTuple((PyObject[])this.args.clone());
                }
                return callable.__call__(this.args);
            }
        };
    }

    private static int py2int(PyObject obj, int defaultValue, String msg) {
        if (obj instanceof PyNone) {
            return defaultValue;
        }
        int value = defaultValue;
        try {
            value = Py.py2int(obj);
        }
        catch (PyException pyEx) {
            if (Py.matchException(pyEx, Py.TypeError)) {
                throw Py.ValueError(msg);
            }
            throw pyEx;
        }
        return value;
    }

    public static PyIterator islice(final PyObject iterable, PyObject startObj, PyObject stopObj, PyObject stepObj) {
        final int stop = itertools.py2int(stopObj, 0, "Stop argument must be a non-negative integer or None");
        final int start = itertools.py2int(startObj, 0, "Start argument must be a non-negative integer or None");
        final int step = itertools.py2int(stepObj, 1, "Step argument must be a non-negative integer or None");
        final boolean stopNone = stopObj instanceof PyNone;
        if (start < 0 || step < 0 || stop < 0) {
            throw Py.ValueError("Indices for islice() must be non-negative integers");
        }
        if (step == 0) {
            throw Py.ValueError("Step must be one or larger for islice()");
        }
        return new ItertoolsIterator(){
            int counter;
            int lastCount;
            PyObject iter;
            {
                this.counter = start;
                this.lastCount = 0;
                this.iter = iterable.__iter__();
            }

            public PyObject __iternext__() {
                PyObject result = null;
                if (this.counter >= stop && !stopNone) {
                    return null;
                }
                while (this.lastCount <= this.counter) {
                    result = this.nextElement(this.iter);
                    ++this.lastCount;
                }
                this.counter += step;
                return result;
            }
        };
    }

    public static PyIterator islice(PyObject iterable, PyObject stopObj) {
        return itertools.islice(iterable, new PyInteger(0), stopObj, new PyInteger(1));
    }

    public static PyIterator islice(PyObject iterable, PyObject start, PyObject stopObj) {
        return itertools.islice(iterable, start, stopObj, new PyInteger(1));
    }

    public static PyIterator ifilter(PyObject predicate, PyObject iterable) {
        return new FilterIterator(predicate, iterable, true);
    }

    public static PyIterator ifilterfalse(PyObject predicate, PyObject iterable) {
        return new FilterIterator(predicate, iterable, false);
    }

    public static PyIterator izip(PyObject[] argstar) {
        final int itemsize = argstar.length;
        if (itemsize == 0) {
            return (PyIterator)new PyXRange(0).__iter__();
        }
        final PyObject[] iters = new PyObject[itemsize];
        for (int i = 0; i < itemsize; ++i) {
            PyObject iter = argstar[i].__iter__();
            if (iter == null) {
                throw Py.TypeError("izip argument #" + (i + 1) + " must support iteration");
            }
            iters[i] = iter;
        }
        return new ItertoolsIterator(){

            /*
             * WARNING - void declaration
             */
            public PyObject __iternext__() {
                if (itemsize == 0) {
                    return null;
                }
                PyObject[] next = new PyObject[itemsize];
                int n = 0;
                while (n < itemsize) {
                    void item;
                    PyObject i = this.nextElement(iters[n]);
                    if (i == null) {
                        return null;
                    }
                    next[item] = i;
                    ++item;
                }
                return new PyTuple(next);
            }
        };
    }

    public static PyIterator starmap(PyObject[] starargs) {
        if (starargs.length != 2) {
            throw Py.TypeError("starmap requires 2 arguments, got " + starargs.length);
        }
        final PyObject callable = starargs[0];
        final PyObject iterator = starargs[1].__iter__();
        return new ItertoolsIterator(){

            public PyObject __iternext__() {
                PyObject args = this.nextElement(iterator);
                PyObject result = null;
                if (args != null) {
                    if (!args.getClass().isAssignableFrom(PyTuple.class)) {
                        throw Py.TypeError("iterator must return a tuple");
                    }
                    PyTuple argTuple = (PyTuple)args;
                    result = callable.__call__(argTuple.getArray());
                }
                return result;
            }
        };
    }

    public static PyIterator dropwhile(PyObject predicate, PyObject iterable) {
        return new WhileIterator(predicate, iterable, true);
    }

    public static PyIterator takewhile(PyObject predicate, PyObject iterable) {
        return new WhileIterator(predicate, iterable, false);
    }

    public static PyIterator groupby(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("groupby", args, kws, "iterable", "key");
        if (args.length > 2) {
            throw Py.TypeError("groupby takes two arguments, iterable and key");
        }
        PyObject iterable = ap.getPyObject(0);
        PyObject key = ap.getPyObject(1, null);
        return new GroupBy(iterable, key);
    }

    public static PyTuple tee(PyObject iterable, int n) {
        return new PyTuple(PyTeeIterator.makeTees(iterable, n));
    }

    public static PyTuple tee(PyObject iterable) {
        return itertools.tee(iterable, 2);
    }

    private static final class GroupBy
    extends ItertoolsIterator {
        private final PyObject iterator;
        private final PyObject keyFunc;
        private PyObject currentKey;
        private PyObject currentValue;
        private PyObject targetKey;

        private GroupBy(PyObject iterable, PyObject key) {
            this.iterator = iterable.__iter__();
            this.keyFunc = key;
            this.currentKey = this.currentValue = new PyXRange(0);
            this.targetKey = this.currentValue;
        }

        public PyObject __iternext__() {
            while (this.currentKey.equals(this.targetKey)) {
                this.currentValue = this.nextElement(this.iterator);
                if (this.currentValue == null) {
                    return null;
                }
                if (this.keyFunc == null) {
                    this.currentKey = this.currentValue;
                    continue;
                }
                this.currentKey = this.keyFunc.__call__(this.currentValue);
            }
            this.targetKey = this.currentKey;
            return new PyTuple(this.currentKey, new GroupByIterator());
        }

        private class GroupByIterator
        extends ItertoolsIterator {
            private boolean completed = false;

            private GroupByIterator() {
            }

            public PyObject __iternext__() {
                PyObject item = GroupBy.this.currentValue;
                if (this.completed) {
                    return null;
                }
                GroupBy.this.currentValue = this.nextElement(GroupBy.this.iterator);
                if (GroupBy.this.currentValue == null) {
                    this.completed = true;
                } else if (GroupBy.this.keyFunc == null) {
                    GroupBy.this.currentKey = GroupBy.this.currentValue;
                } else {
                    GroupBy.this.currentKey = GroupBy.this.keyFunc.__call__(GroupBy.this.currentValue);
                }
                if (!GroupBy.this.currentKey.equals(GroupBy.this.targetKey)) {
                    this.completed = true;
                }
                return item;
            }
        }
    }

    static class WhileIterator
    extends ItertoolsIterator {
        private PyObject iterator;
        private PyObject predicate;
        private boolean drop;
        private boolean predicateSatisfied;

        WhileIterator(PyObject predicate, PyObject iterable, boolean drop) {
            this.predicate = predicate;
            this.iterator = iterable.__iter__();
            this.drop = drop;
        }

        public PyObject __iternext__() {
            PyObject element;
            while ((element = this.nextElement(this.iterator)) != null) {
                if (!this.predicateSatisfied) {
                    if (this.predicate.__call__(element).__nonzero__() != this.drop) {
                        this.predicateSatisfied = this.drop;
                        return element;
                    }
                    this.predicateSatisfied = !this.drop;
                    continue;
                }
                if (this.drop) {
                    return element;
                }
                return null;
            }
            return null;
        }
    }

    static class FilterIterator
    extends ItertoolsIterator {
        private PyObject predicate;
        private PyObject iterator;
        private boolean filterTrue;

        FilterIterator(PyObject predicate, PyObject iterable, boolean filterTrue) {
            this.predicate = predicate instanceof PyNone ? null : predicate;
            this.iterator = iterable.__iter__();
            this.filterTrue = filterTrue;
        }

        public PyObject __iternext__() {
            PyObject element;
            while ((element = this.nextElement(this.iterator)) != null) {
                boolean booleanValue = this.predicate != null ? this.predicate.__call__(element).__nonzero__() : element.__nonzero__();
                if (booleanValue != this.filterTrue) continue;
                return element;
            }
            return null;
        }
    }

    static abstract class ItertoolsIterator
    extends PyIterator {
        ItertoolsIterator() {
        }

        protected PyObject nextElement(PyObject pyIter) {
            PyObject element = null;
            try {
                element = pyIter.__iternext__();
            }
            catch (PyException pyEx) {
                if (Py.matchException(pyEx, Py.StopIteration)) {
                    this.stopException = pyEx;
                }
                throw pyEx;
            }
            return element;
        }
    }
}

