/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.modules.PyTeeIterator$PyExposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyTeeIterator
extends PyIterator {
    private final int position;
    private int count = 0;
    private final PyObject iterator;
    private final Map<Integer, PyObject> buffer;
    private final int[] offsets;

    PyTeeIterator(PyObject iterator, Map<Integer, PyObject> buffer, int[] offsets, int position) {
        this.iterator = iterator;
        this.buffer = buffer;
        this.offsets = offsets;
        this.position = position;
    }

    @ExposedNew
    static final PyObject tee___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int nargs = args.length;
        if (nargs < 1 || nargs > 1) {
            throw Py.TypeError("tee expected 1 arguments, got " + nargs);
        }
        return PyTeeIterator.makeTees(args[0], 1)[0];
    }

    public static PyTeeIterator[] makeTees(PyObject iterable, int n) {
        if (n < 0) {
            throw Py.ValueError("n must be >= 0");
        }
        PyObject iterator = iterable.__iter__();
        ConcurrentHashMap<Integer, PyObject> buffer = new ConcurrentHashMap<Integer, PyObject>();
        int[] offsets = new int[n];
        PyTeeIterator[] tees = new PyTeeIterator[n];
        for (int i = 0; i < n; ++i) {
            offsets[i] = -1;
            tees[i] = new PyTeeIterator(iterator, buffer, offsets, i);
        }
        return tees;
    }

    protected PyObject nextElement(PyObject pyIter) {
        PyObject element = null;
        try {
            element = pyIter.__iternext__();
        }
        catch (PyException pyEx) {
            if (Py.matchException(pyEx, Py.StopIteration)) {
                this.stopException = pyEx;
            }
            throw pyEx;
        }
        return element;
    }

    public final PyObject tee_next() {
        return this.next();
    }

    @Override
    public PyObject __iternext__() {
        PyObject item;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int j = 0; j < this.offsets.length; ++j) {
            if (max < this.offsets[j]) {
                max = this.offsets[j];
            }
            if (min <= this.offsets[j]) continue;
            min = this.offsets[j];
        }
        if (this.count > max) {
            item = this.nextElement(this.iterator);
            if (item != null) {
                this.buffer.put(this.count, item);
            }
        } else {
            item = this.count < min ? this.buffer.remove(this.count) : this.buffer.get(this.count);
        }
        this.offsets[this.position] = this.count++;
        return item;
    }

    static {
        PyType.addBuilder(PyTeeIterator.class, new PyTeeIterator$PyExposer());
    }
}

