/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.python.core.PyDataDescr;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.objectweb.asm.Type;

public class DescriptorExposer
extends Exposer {
    private Type onType;
    private Type ofType;
    private String name;
    private String getterMethodName;
    private String getterFieldName;
    private String setterMethodName;
    private String setterFieldName;
    private String deleterMethodName;

    public DescriptorExposer(Type onType, String descrName) {
        super(PyDataDescr.class, onType.getClassName() + "$" + descrName + "_descriptor", ASSUPER);
        this.onType = onType;
        this.name = descrName;
    }

    public String getName() {
        return this.name;
    }

    public void addMethodGetter(String methodName, String desc) {
        if (this.hasGetter()) {
            this.error("Descriptor can only have one getter");
        }
        if (Type.getArgumentTypes(desc).length > 0) {
            this.error("Getter can't take arguments");
        }
        this.setOfType(Type.getReturnType(desc));
        this.getterMethodName = methodName;
    }

    public void addFieldGetter(String fieldName, Type fieldType) {
        if (this.hasGetter()) {
            this.error("Can only have one getter for a descriptor");
        }
        this.setOfType(fieldType);
        this.getterFieldName = fieldName;
    }

    public boolean hasGetter() {
        return this.getterMethodName != null || this.getterFieldName != null;
    }

    private void setOfType(Type type) {
        if (this.ofType == null) {
            this.ofType = type;
        } else if (!this.ofType.equals(type)) {
            this.error("Types of the getter and setter must agree");
        }
    }

    public void addMethodSetter(String methodName, String desc) {
        Type[] args;
        if (this.hasSetter()) {
            this.error("Descriptor can only have one setter");
        }
        if ((args = Type.getArgumentTypes(desc)).length > 1) {
            this.error("Setter can only take one argument");
        }
        this.setOfType(args[0]);
        this.setterMethodName = methodName;
    }

    public void addFieldSetter(String fieldName, Type fieldType) {
        if (this.hasSetter()) {
            this.error("Descriptor can only have one setter");
        }
        this.setOfType(fieldType);
        this.setterFieldName = fieldName;
    }

    public boolean hasSetter() {
        return this.setterMethodName != null || this.setterFieldName != null;
    }

    public void addMethodDeleter(String methodName, String desc) {
        this.deleterMethodName = methodName;
    }

    public String toString() {
        return "DescriptorExposer[class=" + this.onType.getClassName() + ", name=" + this.name + "]";
    }

    protected void generate() {
        if (!this.hasGetter()) {
            this.error("A descriptor requires at least a get");
        }
        this.generateConstructor();
        if (this.getterMethodName != null) {
            this.generateMethodGetter();
        } else {
            this.generateFieldGetter();
        }
        if (this.setterMethodName != null) {
            this.generateMethodSetter();
        } else if (this.setterFieldName != null) {
            this.generateFieldSetter();
        }
        this.generateImplement("Set", this.setterMethodName != null || this.setterFieldName != null);
        if (this.deleterMethodName != null) {
            this.generateMethodDeleter();
        }
        this.generateImplement("Delete", this.deleterMethodName != null);
    }

    private void generateConstructor() {
        this.startConstructor(new Type[0]);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn(this.name);
        if (PRIMITIVES.containsKey(this.ofType)) {
            this.mv.visitLdcInsn(PRIMITIVES.get(this.ofType));
        } else {
            this.mv.visitLdcInsn(this.ofType);
        }
        this.superConstructor(STRING, CLASS);
        this.endConstructor();
    }

    private void generateMethodGetter() {
        this.startMethod("invokeGet", OBJECT, PYOBJ);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.call(this.onType, this.getterMethodName, this.ofType, new Type[0]);
        if (PRIMITIVES.containsKey(this.ofType)) {
            this.toPy(this.ofType);
        }
        this.endMethod(176);
    }

    private void generateFieldGetter() {
        this.startMethod("invokeGet", OBJECT, PYOBJ);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.mv.visitFieldInsn(180, this.onType.getInternalName(), this.getterFieldName, this.ofType.getDescriptor());
        if (PRIMITIVES.containsKey(this.ofType)) {
            this.toPy(this.ofType);
        }
        this.endMethod(176);
    }

    private void generateMethodSetter() {
        this.startMethod("invokeSet", VOID, PYOBJ, OBJECT);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.mv.visitVarInsn(25, 2);
        if (PRIMITIVES.containsKey(this.ofType)) {
            this.mv.visitTypeInsn(192, ((Type)PRIMITIVES.get(this.ofType)).getInternalName());
            this.call((Type)PRIMITIVES.get(this.ofType), this.ofType.getClassName() + "Value", this.ofType, new Type[0]);
        } else {
            this.mv.visitTypeInsn(192, this.ofType.getInternalName());
        }
        this.call(this.onType, this.setterMethodName, VOID, this.ofType);
        this.endMethod(177);
    }

    private void generateFieldSetter() {
        this.startMethod("invokeSet", VOID, PYOBJ, OBJECT);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.mv.visitVarInsn(25, 2);
        if (PRIMITIVES.containsKey(this.ofType)) {
            this.mv.visitTypeInsn(192, ((Type)PRIMITIVES.get(this.ofType)).getInternalName());
            this.call((Type)PRIMITIVES.get(this.ofType), this.ofType.getClassName() + "Value", this.ofType, new Type[0]);
        } else {
            this.mv.visitTypeInsn(192, this.ofType.getInternalName());
        }
        this.mv.visitFieldInsn(181, this.onType.getInternalName(), this.setterFieldName, this.ofType.getDescriptor());
        this.endMethod(177);
    }

    private void generateMethodDeleter() {
        this.startMethod("invokeDelete", VOID, PYOBJ);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.call(this.onType, this.deleterMethodName, VOID, new Type[0]);
        this.endMethod(177);
    }

    private void generateImplement(String setOrDelete, boolean implementsIt) {
        this.startMethod("implementsDescr" + setOrDelete, BOOLEAN, new Type[0]);
        this.mv.visitInsn(implementsIt ? 4 : 3);
        this.endMethod(172);
    }

    private void error(String reason) {
        throw new InvalidExposingException(reason + "[class=" + this.onType.getClassName() + ", name=" + this.name + "]");
    }
}

