% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{round2}
\alias{round2}
\title{round2}
\usage{
round2(x, order = 0)
}
\arguments{
\item{x}{number to be rounded}

\item{order}{0 (default) = units, -1 = 0.1, +1 = 10}
}
\value{
rounded number to the specified order
}
\description{
Rounds a number to the specified order. Round half away from zero (this is the difference from built-in \code{round} function.)
}
\examples{
round2(23.5)   # = 24, compare: round(23.5) = 24
round2(23.4)   # = 23
round2(24.5)   # = 25, compare: round(24.5) = 24
round2(-23.5)   # = -24, compare: round(-23.5) = -24
round2(-23.4)   # = -23
round2(-24.5)   # = -25, compare: round(-24.5) = -24
round2(123.456, -1)   # 123.5
round2(123.456, -2)   # 123.46
round2(123.456, 1)  # 120
round2(123.456, 2)  # 100
round2(123.456, 3)  # 0
round2(-123.456, -1)   # -123.5
round2(-123.456, -2)   # -123.46
round2(-123.456, 1)  # -120
round2(-123.456, 2)  # -100
round2(-123.456, 3)  # 0
}
\seealso{
\code{\link{round}}, \code{\link{trunc}}, \code{\link{ceiling}}, \code{\link{floor}}
}
