# Also available as files:
# system.file("extdata", "H.TextGrid", package = "rPraat")
# system.file("extdata", "H_problem.TextGrid", package = "rPraat")
# system.file("extdata", "H.PitchTier", package = "rPraat")
#
# E.g.:
#   tg <- tg.read(system.file("extdata", "H.TextGrid", package = "rPraat"))

#' tg.sample
#'
#' Returns sample TextGrid.
#'
#' @return TextGrid
#' @export
#' @seealso \code{\link{tg.plot}}
#'
#' @examples
#' tg <- tg.sample()
#' tg.plot(tg)
tg.sample <- function() {
    tg <- structure(list(phoneme = structure(list(name = "phoneme", type = "point",
    t = c(0.120889365898715, 0.180597224347416, 0.255441139997666,
    0.323525331333184, 0.375027067444295, 0.435376815025253,
    0.504279694264069, 0.562717206724197, 0.610965695488722,
    0.674057937198658, 0.737962529488432, 0.827253285259762,
    0.868531134448233, 0.918910050365654, 0.974990086094542,
    1.05053934430682, 1.21167268104584, 1.88902324993668, 1.92282441350142,
    1.96615363138769, 2.02116389408869, 2.06893833121809, 2.11783390528662,
    2.1695607451066, 2.22032423657473, 2.27591881435465, 2.31952662340463,
    2.35271936402631, 2.40370606752593, 2.47583170709847, 2.53340121033917,
    2.58361187610004, 2.65895915060935, 2.73945082859849, 2.84348900462963,
    2.9951353595599, 3.0883101125227, 3.14535462546526, 3.21171193910256,
    3.272169808837, 3.33241603782642, 3.38647934980882, 3.45468235960145
    ), label = c("j", "a:", "c", "i", "P\\", "e", "k", "n", "u",
    "t_s", "o", "u", "J\\", "e", "l", "a:", "S", "n", "e", "j",
    "d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h",
    "u", "t_S", "k", "u", "a", "a", "t", "a", "m", "a", "n",
    "a")), .Names = c("name", "type", "t", "label")), phone = structure(list(
    name = "phone", type = "interval", t1 = c(0.008, 0.0965724658757064,
    0.145206265921723, 0.215988182773109, 0.294894097222222,
    0.352156565444145, 0.397897569444444, 0.472856060606061,
    0.535703327922078, 0.589731085526316, 0.632200305451128,
    0.715915568946188, 0.760009490030675, 0.803739120702006,
    0.850767449817518, 0.886294819078947, 0.95152528165236, 0.998454890536723,
    1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
    1.93897010762243, 1.99333715515295, 2.04899063302442, 2.08888602941177,
    2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
    2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
    2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
    2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
    3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
    3.35952210541475, 3.4134365942029, 3.495928125), t2 = c(0.0965724658757064,
    0.145206265921723, 0.215988182773109, 0.294894097222222,
    0.352156565444145, 0.397897569444444, 0.472856060606061,
    0.535703327922078, 0.589731085526316, 0.632200305451128,
    0.715915568946188, 0.760009490030675, 0.803739120702006,
    0.850767449817518, 0.886294819078947, 0.95152528165236, 0.998454890536723,
    1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
    1.93897010762243, 1.99333715515295, 2.04899063302442, 2.08888602941177,
    2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
    2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
    2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
    2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
    3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
    3.35952210541475, 3.4134365942029, 3.495928125, 3.616), label = c("",
    "j", "a:", "c", "i", "P\\", "e", "k", "n", "u", "t_s", "o",
    "?", "u", "J\\", "e", "l", "a:", "S", " ", "n", "e", "j",
    "d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h\\",
    "u", "t_S", "k", "u", "?", "a", "?", "a", "t", "a", "m",
    "a", "n", "a:", "")), .Names = c("name", "type", "t1", "t2",
"label")), syllable = structure(list(name = "syllable", type = "interval",
    t1 = c(0, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
    0.535703327922078, 0.632200305451128, 0.760009490030675,
    0.850767449817518, 0.95152528165236, 1.32072156401475, 1.87136778049296,
    1.99333715515295, 2.19233970905172, 2.3355243821977, 2.514165625,
    2.70333134469697, 2.91140769675926, 3.02360108418367, 3.10631502016129,
    3.2390296474359, 3.35952210541475, 3.495928125), t2 = c(0.0965724658757064,
    0.215988182773109, 0.352156565444145, 0.535703327922078,
    0.632200305451128, 0.760009490030675, 0.850767449817518,
    0.95152528165236, 1.32072156401475, 1.87136778049296, 1.99333715515295,
    2.19233970905172, 2.3355243821977, 2.514165625, 2.70333134469697,
    2.91140769675926, 3.02360108418367, 3.10631502016129, 3.2390296474359,
    3.35952210541475, 3.495928125, 3.616), label = c("", "ja:",
    "ci", "P\\ek", "nu", "t_so", "?u", "J\\e", "la:S", "", "nej",
    "dP\\i:f", "naj", "deZ", "h\\ut_S", "ku", "?a", "?a", "ta",
    "ma", "na:", "")), .Names = c("name", "type", "t1", "t2",
"label")), word = structure(list(name = "word", type = "interval",
    t1 = c(0.008, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
    0.632200305451128, 0.760009490030675, 1.32072156401475, 1.87136778049296,
    2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
    3.495928125), t2 = c(0.0965724658757064, 0.215988182773109,
    0.352156565444145, 0.632200305451128, 0.760009490030675,
    1.32072156401475, 1.87136778049296, 2.19233970905172, 2.514165625,
    2.91140769675926, 3.02360108418367, 3.495928125, 3.616),
    label = c("", "ja", "ti", "reknu", "co", "udelas", "{pause}",
    "nejdriv", "najdes", "Hucku", "a", "Atamana", "")), .Names = c("name",
"type", "t1", "t2", "label")), phrase = structure(list(name = "phrase",
    type = "interval", t1 = 0, t2 = 3.608, label = "Ja ti reknu, co udelas. Nejdriv najdes Hucku a Atamana"), .Names = c("name",
"type", "t1", "t2", "label"))), .Names = c("phoneme", "phone",
"syllable", "word", "phrase"), class = structure(c("list", "0",
"3.616"), .Names = c("", "tmin", "tmax")))

    return(tg)
}

#' tg.sampleProblem
#'
#' Returns sample TextGrid with continuity problem.
#'
#' @return TextGrid
#' @export
#' @seealso \code{\link{tg.repairContinuity}}
#'
#' @examples
#' tg <- tg.sampleProblem()
#' tg2 <- tg.repairContinuity(tg)
#' tg2 <- tg.repairContinuity(tg2)
#' tg.plot(tg2)
tg.sampleProblem <- function() {
    tg <- structure(list(phoneme = structure(list(name = "phoneme", type = "point",
    t = c(0.120889365898715, 0.180597224347416, 0.255441139997666,
    0.323525331333184, 0.375027067444295, 0.435376815025253,
    0.504279694264069, 0.562717206724197, 0.610965695488722,
    0.674057937198658, 0.737962529488432, 0.827253285259762,
    0.868531134448233, 0.918910050365654, 0.974990086094542,
    1.05053934430682, 1.21167268104584, 1.88902324993668, 1.92282441350142,
    1.96615363138769, 2.02116389408869, 2.06893833121809, 2.11783390528662,
    2.1695607451066, 2.22032423657473, 2.27591881435465, 2.31952662340463,
    2.35271936402631, 2.40370606752593, 2.47583170709847, 2.53340121033917,
    2.58361187610004, 2.65895915060935, 2.73945082859849, 2.84348900462963,
    2.9951353595599, 3.0883101125227, 3.14535462546526, 3.21171193910256,
    3.272169808837, 3.33241603782642, 3.38647934980882, 3.45468235960145
    ), label = c("j", "a:", "c", "i", "P\\", "e", "k", "n", "u",
    "t_s", "o", "u", "J\\", "e", "l", "a:", "S", "n", "e", "j",
    "d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h",
    "u", "t_S", "k", "u", "a", "a", "t", "a", "m", "a", "n",
    "a")), .Names = c("name", "type", "t", "label")), phone = structure(list(
    name = "phone", type = "interval", t1 = c(0.008, 0.0965724658757064,
    0.145206265921723, 0.215988182773109, 0.294894097222222,
    0.352156565444145, 0.397897569444444, 0.472856060606061,
    0.535703327922078, 0.589731085526316, 0.632200305451128,
    0.715915568946188, 0.760009490030675, 0.803739120702006,
    0.850767449817518, 0.886294819078947, 0.951, 0.998454890536723,
    1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
    1.93897010762243, 1.99333715515295, 2.0489, 2.08888602941177,
    2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
    2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
    2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
    2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
    3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
    3.35952210541475, 3.4134365942029, 3.495928125), t2 = c(0.0965724658757064,
    0.145206265921723, 0.215988182773109, 0.294894097222222,
    0.352156565444145, 0.397897569444444, 0.472856060606061,
    0.535703327922078, 0.589731085526316, 0.632200305451128,
    0.715915568946188, 0.760009490030675, 0.803739120702006,
    0.850767449817518, 0.886294819078947, 0.95100001, 0.998454890536723,
    1.10262379807692, 1.32072156401475, 1.87136778049296, 1.9066787193804,
    1.93897010762243, 1.99333715515295, 2.04890000001, 2.08888602941177,
    2.14678178116147, 2.19233970905172, 2.24830876409774, 2.30352886461156,
    2.3355243821977, 2.36991434585492, 2.43749778919694, 2.514165625,
    2.55263679567834, 2.61458695652174, 2.70333134469697, 2.7755703125,
    2.91140769675926, 2.96666963493613, 3.02360108418367, 3.07030520488411,
    3.10631502016129, 3.18439423076923, 3.2390296474359, 3.3053099702381,
    3.35952210541475, 3.4134365942029, 3.495928125, 3.616), label = c("",
    "j", "a:", "c", "i", "P\\", "e", "k", "n", "u", "t_s", "o",
    "?", "u", "J\\", "e", "l", "a:", "S", " ", "n", "e", "j",
    "d", "P\\", "i:", "f", "n", "a", "j", "d", "e", "Z", "h\\",
    "u", "t_S", "k", "u", "?", "a", "?", "a", "t", "a", "m",
    "a", "n", "a:", "")), .Names = c("name", "type", "t1", "t2",
"label")), syllable = structure(list(name = "syllable", type = "interval",
    t1 = c(0, 0.0965724658757064, 0.215988182773109, 0.352156565444145,
    0.535703327922078, 0.632200305451128, 0.760009490030675,
    0.850767449817518, 0.95152528165236, 1.32072156401475, 1.87136778049296,
    1.99333715515295, 2.19233970905172, 2.3355243821977, 2.514165625,
    2.70333134469697, 2.91140769675926, 3.02360108418367, 3.10631502016129,
    3.2390296474359, 3.35952210541475, 3.495928125), t2 = c(0.0965724658757064,
    0.215988182773109, 0.352156565444145, 0.535703327922078,
    0.632200305451128, 0.760009490030675, 0.850767449817518,
    0.95152528165236, 1.32072156401475, 1.87136778049296, 1.99333715515295,
    2.19233970905172, 2.3355243821977, 2.514165625, 2.70333134469697,
    2.91140769675926, 3.02360108418367, 3.10631502016129, 3.2390296474359,
    3.35952210541475, 3.495928125, 3.616), label = c("", "ja:",
    "ci", "P\\ek", "nu", "t_so", "?u", "J\\e", "la:S", "", "nej",
    "dP\\i:f", "naj", "deZ", "h\\ut_S", "ku", "?a", "?a", "ta",
    "ma", "na:", "")), .Names = c("name", "type", "t1", "t2",
"label")), word = structure(list(name = "word", type = "interval",
    t1 = c(0.008, 0.0965724658757064, 0.2158999, 0.352156565444145,
    0.632200305451128, 0.7601, 1.32072156401475, 1.87136778049296,
    2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
    3.495928125), t2 = c(0.0965724658757064, 0.2159, 0.352156565444145,
    0.632200305451128, 0.76, 1.32072156401475, 1.87136778049296,
    2.19233970905172, 2.514165625, 2.91140769675926, 3.02360108418367,
    3.495928125, 3.616), label = c("", "ja", "ti", "eeknu", "co",
    "udelas", "{pause}", "nejdriv", "najdes", "Hucku", "a", "Atamana",
    "")), .Names = c("name", "type", "t1", "t2", "label")), phrase = structure(list(
    name = "phrase", type = "interval", t1 = 0, t2 = 3.608, label = "Ja ti reknu, co udelas. Nejdriv najdes Hucku a Atamana"), .Names = c("name",
"type", "t1", "t2", "label"))), .Names = c("phoneme", "phone",
"syllable", "word", "phrase"), class = structure(c("list", "0",
"3.616"), .Names = c("", "tmin", "tmax")))

    return(tg)
}

#' pt.sample
#'
#' Returns sample PitchTier.
#'
#' @return PitchTier
#' @export
#' @seealso \code{\link{pt.plot}}
#'
#' @examples
#' pt <- pt.sample()
#' pt.plot(pt)
pt.sample <- function() {
    pt <- structure(list(t = c(0.0935625, 0.1035625, 0.1135625, 0.1235625,
    0.1335625, 0.1435625, 0.1535625, 0.1635625, 0.1735625, 0.1835625,
    0.1935625, 0.2035625, 0.2135625, 0.2235625, 0.2335625, 0.2935625,
    0.3035625, 0.3135625, 0.3235625, 0.3335625, 0.3435625, 0.3535625,
    0.3635625, 0.3735625, 0.3835625, 0.3935625, 0.4035625, 0.4135625,
    0.4235625, 0.4335625, 0.4435625, 0.4535625, 0.4635625, 0.4735625,
    0.4835625, 0.5335625, 0.5435625, 0.5535625, 0.5635625, 0.5735625,
    0.5835625, 0.5935625, 0.6035625, 0.6135625, 0.6235625, 0.6335625,
    0.6435625, 0.7635625, 0.7735625, 0.7835625, 0.7935625, 0.8035625,
    0.8135625, 0.8235625, 0.8335625, 0.8435625, 0.8535625, 0.8635625,
    0.8735625, 0.8835625, 0.8935625, 0.9035625, 0.9135625, 0.9235625,
    0.9335625, 0.9435625, 0.9535625, 0.9635625, 0.9735625, 0.9835625,
    0.9935625, 1.0035625, 1.0135625, 1.0235625, 1.0335625, 1.0435625,
    1.0535625, 1.0635625, 1.0735625, 1.8835625, 1.8935625, 1.9035625,
    1.9135625, 1.9235625, 1.9335625, 1.9435625, 1.9535625, 1.9635625,
    1.9735625, 1.9835625, 1.9935625, 2.0035625, 2.0135625, 2.0235625,
    2.0335625, 2.0435625, 2.0535625, 2.0635625, 2.0735625, 2.0835625,
    2.0935625, 2.1035625, 2.1135625, 2.1235625, 2.1335625, 2.1435625,
    2.1535625, 2.1635625, 2.1735625, 2.1835625, 2.1935625, 2.2035625,
    2.2135625, 2.2235625, 2.2335625, 2.2435625, 2.2535625, 2.2635625,
    2.2735625, 2.2835625, 2.2935625, 2.3035625, 2.3135625, 2.3235625,
    2.3335625, 2.3435625, 2.3535625, 2.3635625, 2.3735625, 2.3835625,
    2.3935625, 2.4035625, 2.4135625, 2.4235625, 2.4335625, 2.4435625,
    2.4535625, 2.4635625, 2.4735625, 2.4835625, 2.4935625, 2.5035625,
    2.5135625, 2.5235625, 2.5335625, 2.5435625, 2.5535625, 2.5635625,
    2.5735625, 2.5835625, 2.5935625, 2.6035625, 2.6135625, 2.6235625,
    2.7735625, 2.7835625, 2.7935625, 2.8035625, 2.8135625, 2.8235625,
    2.8335625, 2.8435625, 2.8535625, 2.8635625, 2.8735625, 2.8835625,
    2.8935625, 2.9035625, 2.9135625, 2.9735625, 2.9835625, 2.9935625,
    3.0835625, 3.0935625, 3.1035625, 3.1135625, 3.1235625, 3.1835625,
    3.1935625, 3.2035625, 3.2135625, 3.2235625, 3.2335625, 3.2435625,
    3.2535625, 3.2635625, 3.2735625, 3.2835625, 3.2935625, 3.3035625,
    3.3135625, 3.3235625, 3.3335625, 3.3435625, 3.3535625, 3.3635625,
    3.3735625, 3.3835625, 3.3935625, 3.4035625, 3.4135625, 3.4235625,
    3.4335625, 3.4435625, 3.4535625, 3.4635625, 3.4735625, 3.4835625,
    3.4935625), f = c(210.062730604157, 216.000196664877, 219.493067264917,
    221.285940333729, 224.36498589873, 230.294721059186, 215.384932287278,
    203.822697661509, 192.487360695774, 189.580336693526, 192.010434279107,
    195.546951066892, 195.850901240659, 194.155083009587, 196.718508016374,
    263.360850890751, 270.839100386271, 273.781213701986, 274.477050697928,
    273.731416381412, 269.116875870315, 255.938338875776, 249.020739362198,
    253.605684139787, 255.081182343559, 257.626948880897, 261.542408896129,
    263.874974051543, 259.376303268924, 249.874050194761, 244.346302349768,
    238.955773132525, 233.334171955406, 228.259396501552, 238.600903437817,
    256.704350631582, 250.505302942172, 245.871566074717, 240.46776707795,
    231.739728498653, 224.096816353289, 218.31420157621, 208.571102020563,
    202.605591647841, 196.42453309938, 188.124951679469, 190.255400192583,
    130.339830499355, 131.422275593081, 130.375240804352, 131.80845758233,
    142.993210985898, 163.086311438615, 170.930003795472, 179.103957377679,
    183.925712800319, 183.708720734564, 179.324279762828, 179.815340050368,
    180.891628172382, 180.152499814796, 174.615487687711, 170.051914230606,
    168.286965420936, 161.690798518359, 157.248717185988, 153.43139380722,
    150.018603806651, 149.294032098336, 150.659001928989, 150.036514446679,
    145.597586703768, 144.096737362489, 138.389894719079, 135.058732367581,
    139.947635859238, 139.801102125312, 125.001688237588, 132.863609653836,
    209.639731409055, 212.651774291658, 214.263711114672, 208.596838587026,
    207.417017067516, 205.896156071496, 204.237633185179, 203.958769396148,
    206.17780711045, 209.024291208526, 211.176511609948, 208.611571275892,
    198.818598493777, 192.232732519572, 190.45408958964, 196.591038969483,
    209.64764000854, 217.914090385371, 229.344890791382, 241.961023002769,
    245.341260835484, 258.404655176344, 264.497858603965, 267.897181403162,
    269.544598222722, 272.401183884358, 275.224750717397, 268.332220166645,
    257.354140347377, 263.152167356754, 270.182436280803, 282.526571900806,
    290.817631479134, 290.309405567278, 287.470160062553, 281.211085097782,
    274.595809563152, 262.780653649015, 262.426351901909, 263.826052710528,
    266.040128338263, 267.395651401899, 268.390180030573, 268.827018256277,
    267.139116916271, 262.161148741023, 247.817246433156, 239.29922673489,
    239.997809826399, 245.401970170869, 247.604823503263, 248.016032818953,
    248.193575634296, 247.122000583395, 238.646694076005, 231.586314416343,
    220.207694900041, 218.736118387651, 191.999146527106, 192.658264872739,
    193.537356424397, 190.555605530456, 190.584099438807, 190.382196420787,
    200.876282309822, 204.67346466601, 215.54918365073, 217.285728368339,
    216.114998591509, 207.033409425367, 201.07800889974, 199.756746823744,
    194.630624629961, 193.287010582472, 202.387223155445, 214.765766211789,
    211.424350451087, 215.495977618704, 217.811569429731, 217.393642207838,
    218.612486614289, 220.208234200306, 220.63229383082, 220.255358340888,
    221.081834151832, 220.979546322984, 215.842694446365, 205.918141427629,
    200.429951632128, 185.191053751928, 199.515885856117, 199.799817380161,
    196.152600306061, 199.417690685637, 202.251943733849, 198.406454456676,
    198.546294242503, 201.468815590477, 207.167735931803, 197.24235841142,
    192.672020346964, 193.014500541187, 194.807344999663, 195.028206757606,
    200.82583284068, 206.003615672747, 204.867353800571, 203.413384147931,
    201.75281351547, 200.593313777613, 195.140565337496, 189.150055732336,
    185.326578109853, 179.688544688706, 174.905314080388, 171.534920048563,
    166.594639799738, 165.826947538547, 162.724141783348, 160.706032197959,
    160.870776102449, 159.572532516518, 154.14529425336, 152.699424431425,
    153.023853237342, 157.128947241149, 160.505660143832, 161.468571250085,
    162.42251152617, 161.70257708723), tmin = 0, tmax = 3.617125), .Names = c("t",
    "f", "tmin", "tmax"))

    return(pt)
}

#' it.sample
#'
#' Returns sample IntensityTier.
#'
#' @return IntensityTier
#' @export
#' @seealso \code{\link{it.plot}}
#'
#' @examples
#' it <- it.sample()
#' it.plot(it)
it.sample <- function() {
    it <- structure(list(t = c(0.0501814058956916, 0.061609977324263, 0.0730385487528345,
    0.0844671201814059, 0.0958956916099773, 0.107324263038549, 0.11875283446712,
    0.130181405895692, 0.141609977324263, 0.153038548752834, 0.164467120181406,
    0.175895691609977, 0.187324263038549, 0.19875283446712, 0.210181405895692,
    0.221609977324263, 0.233038548752834, 0.244467120181406, 0.255895691609977,
    0.267324263038549, 0.27875283446712, 0.290181405895692, 0.301609977324263,
    0.313038548752834, 0.324467120181406, 0.335895691609977, 0.347324263038549,
    0.35875283446712, 0.370181405895692, 0.381609977324263, 0.393038548752834,
    0.404467120181406, 0.415895691609977, 0.427324263038549, 0.43875283446712,
    0.450181405895692, 0.461609977324263, 0.473038548752834, 0.484467120181406,
    0.495895691609977),
    i = c(59.5715903919772, 64.2433970281169,
    66.7307025767877, 68.6118601972034, 69.64503935886, 69.9890705893054,
    70.0931250569067, 69.9080233229584, 69.5408798931165, 68.6145599393597,
    67.7338052604723, 68.8843393012335, 70.4440821351615, 71.3240051264438,
    71.6253943894252, 71.6384332518872, 71.6143276399569, 71.1700597706145,
    70.095823123869, 68.8978679914131, 68.6011647679974, 69.5956454731659,
    70.8841436215361, 71.627781998734, 71.8105755630646, 71.397700225839,
    70.1676187462884, 67.8707663965455, 64.1717622005677, 59.2915859514638,
    56.5792583100872, 58.2129564806205, 58.4726837633976, 58.43640324365,
    64.9729454833362, 69.3800338825861, 70.8984471257152, 70.2640179212008,
    68.0519528346286, 64.9896327040883), tmin = 0, tmax = 0.546077097505669), .Names = c("t", "i", "tmin", "tmax"))

    return(it)
}


